/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.channel.paging;

import com.amity.socialcloud.sdk.chat.data.channel.ChannelHelper;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel;
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannelFilter;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreatorKt;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J=\u0010\u0014\u001a\u00020\u00112\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/channel/paging/ChannelKeyCreator;", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "types", "", "Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannel$Type;", "filter", "Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannelFilter;", "includingTags", "Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;", "excludingTags", "isDeleted", "", "<init>", "(Ljava/util/Set;Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannelFilter;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "toMap", "", "", "", "getFilterQuery", "getConditionStatement", "(Ljava/util/Set;Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannelFilter;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;)Ljava/lang/String;", "amity-sdk_release"})
public final class ChannelKeyCreator
implements DynamicQueryStreamKeyCreator {
    @NotNull
    private final Set<AmityChannel.Type> types;
    @NotNull
    private final AmityChannelFilter filter;
    @NotNull
    private final AmityTags includingTags;
    @NotNull
    private final AmityTags excludingTags;
    @Nullable
    private final Boolean isDeleted;

    public ChannelKeyCreator(@NotNull Set<? extends AmityChannel.Type> types, @NotNull AmityChannelFilter filter, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        this.types = types;
        this.filter = filter;
        this.includingTags = includingTags;
        this.excludingTags = excludingTags;
        this.isDeleted = isDeleted;
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"types", ChannelHelper.INSTANCE.getChannelTypes(this.types));
        pairArray[1] = TuplesKt.to((Object)"filter", (Object)this.filter.getApiKey());
        pairArray[2] = TuplesKt.to((Object)"includingTags", (Object)this.includingTags);
        pairArray[3] = TuplesKt.to((Object)"excludingTags", (Object)this.excludingTags);
        Object object = this.isDeleted;
        if (object == null || (object = ((Boolean)object).toString()) == null) {
            object = "null";
        }
        pairArray[4] = TuplesKt.to((Object)"isDeleted", (Object)object);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public String getFilterQuery() {
        return this.getConditionStatement(this.types, this.filter, this.includingTags, this.excludingTags, this.isDeleted);
    }

    private final String getConditionStatement(Set<? extends AmityChannel.Type> types, AmityChannelFilter filter, AmityTags includingTags, AmityTags excludingTags, Boolean isDeleted) {
        String string;
        String channelTypeFilterStatement = "channel.channelType IN (" + DynamicQueryStreamKeyCreatorKt.toSqlArray(ChannelHelper.INSTANCE.getChannelTypes(types)) + ")";
        String userId = new SessionLocalDataStore().getActiveUserId();
        String memebershipFilterStatement = filter == AmityChannelFilter.ALL ? "" : " and channel.channelId IN (SELECT channelId from channel_membership where membership IN (" + DynamicQueryStreamKeyCreatorKt.toSqlArray(filter.getMemberships()) + ") and userId = '" + userId + "')";
        String includingTagsFilterStatement = includingTags.isEmpty() ? "" : " and channel.channelId IN (SELECT channelId from channel_tag where tagName IN (" + DynamicQueryStreamKeyCreatorKt.toSqlArray(includingTags) + "))";
        String excludingTagsFilterStatement = excludingTags.isEmpty() ? "" : " and channel.channelId not IN (SELECT channelId from channel_tag where tagName IN (" + DynamicQueryStreamKeyCreatorKt.toSqlArray(excludingTags) + "))";
        Boolean bl = isDeleted;
        if (bl == null) {
            string = "";
        } else if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            string = " and channel.isDeleted = 1";
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            string = " and channel.isDeleted = 0";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String isDeletedFilterStatement = string;
        return channelTypeFilterStatement + memebershipFilterStatement + includingTagsFilterStatement + excludingTagsFilterStatement + isDeletedFilterStatement;
    }

    @Override
    @Nullable
    public String optionalFilterQuery() {
        return DynamicQueryStreamKeyCreator.super.optionalFilterQuery();
    }
}

