package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Query
import com.ekoapp.ekosdk.internal.data.model.InvitationEntity

@Dao
abstract class InvitationDao : EkoObjectDao<InvitationEntity>() {
    @Delete
    abstract override fun delete(invitation: InvitationEntity)

    @Query("DELETE from invitation")
    abstract override fun deleteAll()

    @Query("SELECT * FROM invitation WHERE targetId = :targetId")
    abstract fun getInvitation(targetId: String): InvitationEntity?

    @Query("UPDATE invitation SET status = :status WHERE invitationId = :invitationId")
    abstract fun updateStatus(
        invitationId: String,
        status: String,
    ): Int
}
