package com.amity.socialcloud.sdk.model.social.community

import android.os.Parcelable
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.amity.socialcloud.sdk.social.domain.community.CommunityAcceptJoinRequestUseCase
import com.amity.socialcloud.sdk.social.domain.community.CommunityCancelJoinRequestUseCase
import com.amity.socialcloud.sdk.social.domain.community.CommunityRejectJoinRequestUseCase
import io.reactivex.rxjava3.core.Completable
import kotlinx.parcelize.Parcelize
import org.joda.time.DateTime

@Parcelize
data class AmityJoinRequest internal constructor(
    private val joinRequestId: String,
    private val type: String,
    private val networkId: String,
    private val targetId: String,
    private val targetType: String,
    private val userId: String,
    private val requestorId: String?,
    private val requestorInternalId: String?,
    private val requestorPublicId: String?,
    private val responderId: String?,
    private val responderInternalId: String?,
    private val responderPublicId: String?,
    private val respondedAt: DateTime?,
    private val createdAt: DateTime?,
    private val updatedAt: DateTime?,
    private val status: AmityJoinRequestStatus?,
    internal var user: AmityUser? = null,
) : Parcelable {

    fun getId(): String = joinRequestId

    fun getType(): String = type

    fun getNetworkId(): String = networkId

    fun getTargetId(): String = targetId

    fun getTargetType(): String = targetType

    fun getUserId(): String = userId

    fun getStatus(): AmityJoinRequestStatus? = status

    // Requestor accessor methods
    fun getRequestorId(): String? = requestorId

    fun getRequestorInternalId(): String? = requestorInternalId

    fun getRequestorPublicId(): String? = requestorPublicId

    // Responder accessor methods
    fun getResponderId(): String? = responderId

    fun getResponderInternalId(): String? = responderInternalId

    fun getResponderPublicId(): String? = responderPublicId

    fun getRespondedAt(): DateTime? = respondedAt

    fun getCreatedAt(): DateTime? = createdAt

    fun getUpdatedAt(): DateTime? = updatedAt

    fun getUser(): AmityUser? {
        return user
    }

    fun approve(): Completable {
        return CommunityAcceptJoinRequestUseCase().execute(targetId, userId)
    }

    fun reject(): Completable {
        return CommunityRejectJoinRequestUseCase().execute(targetId, userId)
    }

    fun cancel(): Completable {
        return CommunityCancelJoinRequestUseCase().execute(targetId = targetId, userId = userId)
    }
}
