package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.MarkerEvent
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus
import com.ekoapp.ekosdk.internal.api.dto.MarkerUpdatedDto
import kotlin.reflect.KClass

internal class MarkerUpdated: MqttEventListener<MarkerUpdatedDto>()  {

    override val type: KClass<MarkerUpdatedDto>
        get() = MarkerUpdatedDto::class

    override fun processEvent(dto: MarkerUpdatedDto) {
        MarkerEventBus.publish(MarkerEvent.MarkerUpdated(getEventName()))
    }

    override fun shouldProcessEvent(dto: MarkerUpdatedDto): Boolean {
        return true
    }
    
    override fun getEventName(): String {
        return "marker.feed-updated"
    }
    
}