package com.amity.socialcloud.sdk.api.core.notificationtray

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.core.domain.notificationtray.get.GetNotificationTrayItemUseCase
import com.amity.socialcloud.sdk.core.domain.notificationtray.get.NotificationTrayLiveObjectUseCase
import com.amity.socialcloud.sdk.core.domain.notificationtray.seen.MarkNotificationTraySeenUseCase
import com.amity.socialcloud.sdk.model.core.notificationtray.AmityNotificationTrayItem
import com.amity.socialcloud.sdk.model.core.notificationtray.AmityNotificationTraySeen
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable

class AmityNotificationTray internal constructor() {

    fun getNotificationTrayItems(): Flowable<PagingData<AmityNotificationTrayItem>> {
        return GetNotificationTrayItemUseCase().execute()
    }

    fun getNotificationTraySeen(): Flowable<AmityNotificationTraySeen> {
        return NotificationTrayLiveObjectUseCase().execute(AmityCoreClient.getUserId())
    }

    fun markTraySeen(): Completable {
        return MarkNotificationTraySeenUseCase().execute()
    }

}