/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap;
import com.ekoapp.ekosdk.internal.PostEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoReactionMapConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonArrayTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.MentioneesConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.PostDao;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class PostDao_Impl
extends PostDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<PostEntity> __insertAdapterOfPostEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final EkoReactionMapConverter __ekoReactionMapConverter = new EkoReactionMapConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final MentioneesConverter __mentioneesConverter = new MentioneesConverter();
    private final JsonArrayTypeConverter __jsonArrayTypeConverter = new JsonArrayTypeConverter();
    private final EntityDeleteOrUpdateAdapter<PostEntity> __deleteAdapterOfPostEntity;
    private final EntityDeleteOrUpdateAdapter<PostEntity> __updateAdapterOfPostEntity;

    public PostDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfPostEntity = new EntityInsertAdapter<PostEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `post` (`postId`,`mid`,`path`,`parentPostId`,`postedUserId`,`sharedUserId`,`metadata`,`sharedCount`,`reactions`,`reactionCount`,`commentCount`,`flagCount`,`structureType`,`editedAt`,`isDeleted`,`targetType`,`targetId`,`postDataType`,`data`,`childPostIds`,`feedType`,`mentionees`,`impression`,`reach`,`hashtags`,`pii`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull PostEntity entity) {
                if (entity.getPostId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getPostId());
                }
                if (entity.getMid() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getMid());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getPath());
                }
                if (entity.getParentPostId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getParentPostId());
                }
                if (entity.getPostedUserId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getPostedUserId());
                }
                if (entity.getSharedUserId() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getSharedUserId());
                }
                String _tmp = PostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp);
                }
                statement.bindLong(8, (long)entity.getSharedCount());
                String _tmp_1 = PostDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(entity.getReactions());
                if (_tmp_1 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_1);
                }
                statement.bindLong(10, (long)entity.getReactionCount());
                statement.bindLong(11, (long)entity.getCommentCount());
                statement.bindLong(12, (long)entity.getFlagCount());
                if (entity.getStructureType() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, entity.getStructureType());
                }
                String _tmp_2 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEditedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, _tmp_2);
                }
                int _tmp_3 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(15, (long)_tmp_3);
                if (entity.getTargetType() == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindText(16, entity.getTargetType());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, entity.getTargetId());
                }
                if (entity.getPostDataType() == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindText(18, entity.getPostDataType());
                }
                String _tmp_4 = PostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getData());
                if (_tmp_4 == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, _tmp_4);
                }
                String _tmp_5 = PostDao_Impl.this.__stringListConverter.stringListToString(entity.getChildPostIds());
                if (_tmp_5 == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, _tmp_5);
                }
                if (entity.getFeedType() == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, entity.getFeedType());
                }
                String _tmp_6 = PostDao_Impl.this.__mentioneesConverter.mentioneesToJson(entity.getMentionees());
                if (_tmp_6 == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindText(22, _tmp_6);
                }
                statement.bindLong(23, (long)entity.getImpression());
                statement.bindLong(24, (long)entity.getReach());
                String _tmp_7 = PostDao_Impl.this.__stringListConverter.stringListToString(entity.getHashtags());
                if (_tmp_7 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_7);
                }
                String _tmp_8 = PostDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getPii());
                if (_tmp_8 == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, _tmp_8);
                }
                String _tmp_9 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_9 == null) {
                    statement.bindNull(27);
                } else {
                    statement.bindText(27, _tmp_9);
                }
                String _tmp_10 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_10 == null) {
                    statement.bindNull(28);
                } else {
                    statement.bindText(28, _tmp_10);
                }
                String _tmp_11 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_11 == null) {
                    statement.bindNull(29);
                } else {
                    statement.bindText(29, _tmp_11);
                }
            }
        };
        this.__deleteAdapterOfPostEntity = new EntityDeleteOrUpdateAdapter<PostEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `post` WHERE `postId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull PostEntity entity) {
                if (entity.getPostId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getPostId());
                }
            }
        };
        this.__updateAdapterOfPostEntity = new EntityDeleteOrUpdateAdapter<PostEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `post` SET `postId` = ?,`mid` = ?,`path` = ?,`parentPostId` = ?,`postedUserId` = ?,`sharedUserId` = ?,`metadata` = ?,`sharedCount` = ?,`reactions` = ?,`reactionCount` = ?,`commentCount` = ?,`flagCount` = ?,`structureType` = ?,`editedAt` = ?,`isDeleted` = ?,`targetType` = ?,`targetId` = ?,`postDataType` = ?,`data` = ?,`childPostIds` = ?,`feedType` = ?,`mentionees` = ?,`impression` = ?,`reach` = ?,`hashtags` = ?,`pii` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `postId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull PostEntity entity) {
                if (entity.getPostId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getPostId());
                }
                if (entity.getMid() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getMid());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getPath());
                }
                if (entity.getParentPostId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getParentPostId());
                }
                if (entity.getPostedUserId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getPostedUserId());
                }
                if (entity.getSharedUserId() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getSharedUserId());
                }
                String _tmp = PostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp);
                }
                statement.bindLong(8, (long)entity.getSharedCount());
                String _tmp_1 = PostDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(entity.getReactions());
                if (_tmp_1 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_1);
                }
                statement.bindLong(10, (long)entity.getReactionCount());
                statement.bindLong(11, (long)entity.getCommentCount());
                statement.bindLong(12, (long)entity.getFlagCount());
                if (entity.getStructureType() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, entity.getStructureType());
                }
                String _tmp_2 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEditedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, _tmp_2);
                }
                int _tmp_3 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(15, (long)_tmp_3);
                if (entity.getTargetType() == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindText(16, entity.getTargetType());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, entity.getTargetId());
                }
                if (entity.getPostDataType() == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindText(18, entity.getPostDataType());
                }
                String _tmp_4 = PostDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getData());
                if (_tmp_4 == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, _tmp_4);
                }
                String _tmp_5 = PostDao_Impl.this.__stringListConverter.stringListToString(entity.getChildPostIds());
                if (_tmp_5 == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, _tmp_5);
                }
                if (entity.getFeedType() == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, entity.getFeedType());
                }
                String _tmp_6 = PostDao_Impl.this.__mentioneesConverter.mentioneesToJson(entity.getMentionees());
                if (_tmp_6 == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindText(22, _tmp_6);
                }
                statement.bindLong(23, (long)entity.getImpression());
                statement.bindLong(24, (long)entity.getReach());
                String _tmp_7 = PostDao_Impl.this.__stringListConverter.stringListToString(entity.getHashtags());
                if (_tmp_7 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_7);
                }
                String _tmp_8 = PostDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getPii());
                if (_tmp_8 == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, _tmp_8);
                }
                String _tmp_9 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_9 == null) {
                    statement.bindNull(27);
                } else {
                    statement.bindText(27, _tmp_9);
                }
                String _tmp_10 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_10 == null) {
                    statement.bindNull(28);
                } else {
                    statement.bindText(28, _tmp_10);
                }
                String _tmp_11 = PostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_11 == null) {
                    statement.bindNull(29);
                } else {
                    statement.bindText(29, _tmp_11);
                }
                if (entity.getPostId() == null) {
                    statement.bindNull(30);
                } else {
                    statement.bindText(30, entity.getPostId());
                }
            }
        };
    }

    @Override
    public void insertImpl(PostEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfPostEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends PostEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfPostEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(List<? extends PostEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfPostEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(PostEntity ekoPost) {
        if (ekoPost == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfPostEntity.handle(_connection, (Object)ekoPost);
            return null;
        });
    }

    @Override
    public void updateImpl(PostEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfPostEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(PostEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            PostDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends PostEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            PostDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(PostEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            PostDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public List<PostEntity> getByIdsNowImpl(List<String> postIds) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from post where post.postId IN (");
        int _inputSize = postIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : postIds) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfParentPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentPostId");
                int _columnIndexOfPostedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postedUserId");
                int _columnIndexOfSharedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sharedUserId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfSharedCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sharedCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfCommentCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentCount");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfStructureType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"structureType");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPostDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postDataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfChildPostIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childPostIds");
                int _columnIndexOfFeedType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"feedType");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfImpression = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"impression");
                int _columnIndexOfReach = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reach");
                int _columnIndexOfHashtags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hashtags");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<PostEntity> _result = new ArrayList<PostEntity>();
                while (_stmt.step()) {
                    PostEntity _item_1 = new PostEntity();
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _item_1.setPostId(_tmpPostId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    _item_1.setMid(_tmpMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item_1.setPath(_tmpPath);
                    String _tmpParentPostId = _stmt.isNull(_columnIndexOfParentPostId) ? null : _stmt.getText(_columnIndexOfParentPostId);
                    _item_1.setParentPostId(_tmpParentPostId);
                    String _tmpPostedUserId = _stmt.isNull(_columnIndexOfPostedUserId) ? null : _stmt.getText(_columnIndexOfPostedUserId);
                    _item_1.setPostedUserId(_tmpPostedUserId);
                    String _tmpSharedUserId = _stmt.isNull(_columnIndexOfSharedUserId) ? null : _stmt.getText(_columnIndexOfSharedUserId);
                    _item_1.setSharedUserId(_tmpSharedUserId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _item_1.setMetadata(_tmpMetadata);
                    int _tmpSharedCount = (int)_stmt.getLong(_columnIndexOfSharedCount);
                    _item_1.setSharedCount(_tmpSharedCount);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                    _item_1.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _item_1.setReactionCount(_tmpReactionCount);
                    int _tmpCommentCount = (int)_stmt.getLong(_columnIndexOfCommentCount);
                    _item_1.setCommentCount(_tmpCommentCount);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _item_1.setFlagCount(_tmpFlagCount);
                    String _tmpStructureType = _stmt.isNull(_columnIndexOfStructureType) ? null : _stmt.getText(_columnIndexOfStructureType);
                    _item_1.setStructureType(_tmpStructureType);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item_1.setEditedAt(_tmpEditedAt);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_3 != 0;
                    _item_1.setDeleted(_tmpIsDeleted);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _item_1.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _item_1.setTargetId(_tmpTargetId);
                    String _tmpPostDataType = _stmt.isNull(_columnIndexOfPostDataType) ? null : _stmt.getText(_columnIndexOfPostDataType);
                    _item_1.setPostDataType(_tmpPostDataType);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _item_1.setData(_tmpData);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfChildPostIds) ? null : _stmt.getText(_columnIndexOfChildPostIds);
                    List<String> _tmpChildPostIds = this.__stringListConverter.stringToStringList(_tmp_5);
                    _item_1.setChildPostIds(_tmpChildPostIds);
                    String _tmpFeedType = _stmt.isNull(_columnIndexOfFeedType) ? null : _stmt.getText(_columnIndexOfFeedType);
                    _item_1.setFeedType(_tmpFeedType);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                    _item_1.setMentionees(_tmpMentionees);
                    int _tmpImpression = (int)_stmt.getLong(_columnIndexOfImpression);
                    _item_1.setImpression(_tmpImpression);
                    int _tmpReach = (int)_stmt.getLong(_columnIndexOfReach);
                    _item_1.setReach(_tmpReach);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfHashtags) ? null : _stmt.getText(_columnIndexOfHashtags);
                    List<String> _tmpHashtags = this.__stringListConverter.stringToStringList(_tmp_7);
                    _item_1.setHashtags(_tmpHashtags);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_8);
                    _item_1.setPii(_tmpPii);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<PostEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public PostEntity getByIdNowImpl(String postIds) {
        String _sql = "SELECT * from post where post.postId IN (?) LIMIT 1";
        return (PostEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from post where post.postId IN (?) LIMIT 1");){
                PostEntity _result;
                int _argIndex = 1;
                if (postIds == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, postIds);
                }
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfParentPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentPostId");
                int _columnIndexOfPostedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postedUserId");
                int _columnIndexOfSharedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sharedUserId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfSharedCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sharedCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfCommentCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentCount");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfStructureType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"structureType");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPostDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postDataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfChildPostIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childPostIds");
                int _columnIndexOfFeedType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"feedType");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfImpression = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"impression");
                int _columnIndexOfReach = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reach");
                int _columnIndexOfHashtags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hashtags");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new PostEntity();
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _result.setPostId(_tmpPostId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    _result.setMid(_tmpMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpParentPostId = _stmt.isNull(_columnIndexOfParentPostId) ? null : _stmt.getText(_columnIndexOfParentPostId);
                    _result.setParentPostId(_tmpParentPostId);
                    String _tmpPostedUserId = _stmt.isNull(_columnIndexOfPostedUserId) ? null : _stmt.getText(_columnIndexOfPostedUserId);
                    _result.setPostedUserId(_tmpPostedUserId);
                    String _tmpSharedUserId = _stmt.isNull(_columnIndexOfSharedUserId) ? null : _stmt.getText(_columnIndexOfSharedUserId);
                    _result.setSharedUserId(_tmpSharedUserId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setMetadata(_tmpMetadata);
                    int _tmpSharedCount = (int)_stmt.getLong(_columnIndexOfSharedCount);
                    _result.setSharedCount(_tmpSharedCount);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    int _tmpCommentCount = (int)_stmt.getLong(_columnIndexOfCommentCount);
                    _result.setCommentCount(_tmpCommentCount);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmpStructureType = _stmt.isNull(_columnIndexOfStructureType) ? null : _stmt.getText(_columnIndexOfStructureType);
                    _result.setStructureType(_tmpStructureType);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_3 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpPostDataType = _stmt.isNull(_columnIndexOfPostDataType) ? null : _stmt.getText(_columnIndexOfPostDataType);
                    _result.setPostDataType(_tmpPostDataType);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _result.setData(_tmpData);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfChildPostIds) ? null : _stmt.getText(_columnIndexOfChildPostIds);
                    List<String> _tmpChildPostIds = this.__stringListConverter.stringToStringList(_tmp_5);
                    _result.setChildPostIds(_tmpChildPostIds);
                    String _tmpFeedType = _stmt.isNull(_columnIndexOfFeedType) ? null : _stmt.getText(_columnIndexOfFeedType);
                    _result.setFeedType(_tmpFeedType);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                    _result.setMentionees(_tmpMentionees);
                    int _tmpImpression = (int)_stmt.getLong(_columnIndexOfImpression);
                    _result.setImpression(_tmpImpression);
                    int _tmpReach = (int)_stmt.getLong(_columnIndexOfReach);
                    _result.setReach(_tmpReach);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfHashtags) ? null : _stmt.getText(_columnIndexOfHashtags);
                    List<String> _tmpHashtags = this.__stringListConverter.stringToStringList(_tmp_7);
                    _result.setHashtags(_tmpHashtags);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_8);
                    _result.setPii(_tmpPii);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                PostEntity postEntity = _result;
                return postEntity;
            }
        });
    }

    @Override
    public Flowable<PostEntity> getLatestChildrenPostImpl(String targetId, String targetType, List<String> postTypes, int hash, int nonce, DateTime now, Boolean includeDeleted, String feedType) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from post, amity_paging_id where post.targetType = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and post.targetId = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  and post.isDeleted = (case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then post.isDeleted else ");
        _stringBuilder.append("?");
        _stringBuilder.append(" end) and post.feedType = (case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then post.feedType else ");
        _stringBuilder.append("?");
        _stringBuilder.append(" end) and post.postDataType in (");
        int _inputSize = postTypes.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")  and post.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and post.postId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") and amity_paging_id.nonce = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") ) order by post.updatedAt  desc limit 1");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"post", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                PostEntity _result;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetType);
                }
                _argIndex = 2;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                _argIndex = 3;
                Integer n = includeDeleted == null ? null : (_tmp = Integer.valueOf(includeDeleted != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 4;
                Integer n2 = includeDeleted == null ? null : (_tmp_1 = Integer.valueOf(includeDeleted != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 5;
                if (feedType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, feedType);
                }
                _argIndex = 6;
                if (feedType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, feedType);
                }
                _argIndex = 7;
                for (String _item : postTypes) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                _argIndex = 7 + _inputSize;
                String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp_2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_2);
                }
                _argIndex = 8 + _inputSize;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 9 + _inputSize;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfParentPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentPostId");
                int _columnIndexOfPostedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postedUserId");
                int _columnIndexOfSharedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sharedUserId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfSharedCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sharedCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfCommentCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentCount");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfStructureType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"structureType");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPostDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postDataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfChildPostIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childPostIds");
                int _columnIndexOfFeedType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"feedType");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfImpression = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"impression");
                int _columnIndexOfReach = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reach");
                int _columnIndexOfHashtags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hashtags");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new PostEntity();
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _result.setPostId(_tmpPostId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    _result.setMid(_tmpMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpParentPostId = _stmt.isNull(_columnIndexOfParentPostId) ? null : _stmt.getText(_columnIndexOfParentPostId);
                    _result.setParentPostId(_tmpParentPostId);
                    String _tmpPostedUserId = _stmt.isNull(_columnIndexOfPostedUserId) ? null : _stmt.getText(_columnIndexOfPostedUserId);
                    _result.setPostedUserId(_tmpPostedUserId);
                    String _tmpSharedUserId = _stmt.isNull(_columnIndexOfSharedUserId) ? null : _stmt.getText(_columnIndexOfSharedUserId);
                    _result.setSharedUserId(_tmpSharedUserId);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    _result.setMetadata(_tmpMetadata);
                    int _tmpSharedCount = (int)_stmt.getLong(_columnIndexOfSharedCount);
                    _result.setSharedCount(_tmpSharedCount);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    int _tmpCommentCount = (int)_stmt.getLong(_columnIndexOfCommentCount);
                    _result.setCommentCount(_tmpCommentCount);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmpStructureType = _stmt.isNull(_columnIndexOfStructureType) ? null : _stmt.getText(_columnIndexOfStructureType);
                    _result.setStructureType(_tmpStructureType);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmp_6 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_6 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpPostDataType = _stmt.isNull(_columnIndexOfPostDataType) ? null : _stmt.getText(_columnIndexOfPostDataType);
                    _result.setPostDataType(_tmpPostDataType);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                    _result.setData(_tmpData);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfChildPostIds) ? null : _stmt.getText(_columnIndexOfChildPostIds);
                    List<String> _tmpChildPostIds = this.__stringListConverter.stringToStringList(_tmp_8);
                    _result.setChildPostIds(_tmpChildPostIds);
                    String _tmpFeedType = _stmt.isNull(_columnIndexOfFeedType) ? null : _stmt.getText(_columnIndexOfFeedType);
                    _result.setFeedType(_tmpFeedType);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_9);
                    _result.setMentionees(_tmpMentionees);
                    int _tmpImpression = (int)_stmt.getLong(_columnIndexOfImpression);
                    _result.setImpression(_tmpImpression);
                    int _tmpReach = (int)_stmt.getLong(_columnIndexOfReach);
                    _result.setReach(_tmpReach);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfHashtags) ? null : _stmt.getText(_columnIndexOfHashtags);
                    List<String> _tmpHashtags = this.__stringListConverter.stringToStringList(_tmp_10);
                    _result.setHashtags(_tmpHashtags);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_11);
                    _result.setPii(_tmpPii);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                PostEntity postEntity = _result;
                return postEntity;
            }
        });
    }

    @Override
    public Flowable<PostEntity> getLatestParentPostImpl(String targetId, String targetType, int hash, int nonce, DateTime now, Boolean isDeleted, String feedType) {
        String _sql = "SELECT * from post where post.targetType = ? and post.targetId = ?  and post.parentPostId is null and post.isDeleted = (case when ? is null then post.isDeleted else ? end) and post.feedType = (case when ? is null then post.feedType else ? end) and post.updatedAt > ? and post.postId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by post.updatedAt  desc limit 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"post", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from post where post.targetType = ? and post.targetId = ?  and post.parentPostId is null and post.isDeleted = (case when ? is null then post.isDeleted else ? end) and post.feedType = (case when ? is null then post.feedType else ? end) and post.updatedAt > ? and post.postId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by post.updatedAt  desc limit 1");){
                PostEntity _result;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetType);
                }
                _argIndex = 2;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                _argIndex = 3;
                Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 4;
                Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 5;
                if (feedType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, feedType);
                }
                _argIndex = 6;
                if (feedType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, feedType);
                }
                _argIndex = 7;
                String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp_2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_2);
                }
                _argIndex = 8;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 9;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfParentPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentPostId");
                int _columnIndexOfPostedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postedUserId");
                int _columnIndexOfSharedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sharedUserId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfSharedCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sharedCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfCommentCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentCount");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfStructureType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"structureType");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPostDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postDataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfChildPostIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childPostIds");
                int _columnIndexOfFeedType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"feedType");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfImpression = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"impression");
                int _columnIndexOfReach = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reach");
                int _columnIndexOfHashtags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hashtags");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new PostEntity();
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _result.setPostId(_tmpPostId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    _result.setMid(_tmpMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpParentPostId = _stmt.isNull(_columnIndexOfParentPostId) ? null : _stmt.getText(_columnIndexOfParentPostId);
                    _result.setParentPostId(_tmpParentPostId);
                    String _tmpPostedUserId = _stmt.isNull(_columnIndexOfPostedUserId) ? null : _stmt.getText(_columnIndexOfPostedUserId);
                    _result.setPostedUserId(_tmpPostedUserId);
                    String _tmpSharedUserId = _stmt.isNull(_columnIndexOfSharedUserId) ? null : _stmt.getText(_columnIndexOfSharedUserId);
                    _result.setSharedUserId(_tmpSharedUserId);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    _result.setMetadata(_tmpMetadata);
                    int _tmpSharedCount = (int)_stmt.getLong(_columnIndexOfSharedCount);
                    _result.setSharedCount(_tmpSharedCount);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    int _tmpCommentCount = (int)_stmt.getLong(_columnIndexOfCommentCount);
                    _result.setCommentCount(_tmpCommentCount);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmpStructureType = _stmt.isNull(_columnIndexOfStructureType) ? null : _stmt.getText(_columnIndexOfStructureType);
                    _result.setStructureType(_tmpStructureType);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmp_6 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_6 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpPostDataType = _stmt.isNull(_columnIndexOfPostDataType) ? null : _stmt.getText(_columnIndexOfPostDataType);
                    _result.setPostDataType(_tmpPostDataType);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                    _result.setData(_tmpData);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfChildPostIds) ? null : _stmt.getText(_columnIndexOfChildPostIds);
                    List<String> _tmpChildPostIds = this.__stringListConverter.stringToStringList(_tmp_8);
                    _result.setChildPostIds(_tmpChildPostIds);
                    String _tmpFeedType = _stmt.isNull(_columnIndexOfFeedType) ? null : _stmt.getText(_columnIndexOfFeedType);
                    _result.setFeedType(_tmpFeedType);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_9);
                    _result.setMentionees(_tmpMentionees);
                    int _tmpImpression = (int)_stmt.getLong(_columnIndexOfImpression);
                    _result.setImpression(_tmpImpression);
                    int _tmpReach = (int)_stmt.getLong(_columnIndexOfReach);
                    _result.setReach(_tmpReach);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfHashtags) ? null : _stmt.getText(_columnIndexOfHashtags);
                    List<String> _tmpHashtags = this.__stringListConverter.stringToStringList(_tmp_10);
                    _result.setHashtags(_tmpHashtags);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_11);
                    _result.setPii(_tmpPii);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                PostEntity postEntity = _result;
                return postEntity;
            }
        });
    }

    @Override
    public Flowable<PostEntity> getPostImpl(String postIds) {
        String _sql = "SELECT * from post where post.postId IN (?) LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"post"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from post where post.postId IN (?) LIMIT 1");){
                PostEntity _result;
                int _argIndex = 1;
                if (postIds == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, postIds);
                }
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfParentPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentPostId");
                int _columnIndexOfPostedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postedUserId");
                int _columnIndexOfSharedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sharedUserId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfSharedCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sharedCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfCommentCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentCount");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfStructureType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"structureType");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPostDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postDataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfChildPostIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childPostIds");
                int _columnIndexOfFeedType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"feedType");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfImpression = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"impression");
                int _columnIndexOfReach = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reach");
                int _columnIndexOfHashtags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hashtags");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new PostEntity();
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _result.setPostId(_tmpPostId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    _result.setMid(_tmpMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpParentPostId = _stmt.isNull(_columnIndexOfParentPostId) ? null : _stmt.getText(_columnIndexOfParentPostId);
                    _result.setParentPostId(_tmpParentPostId);
                    String _tmpPostedUserId = _stmt.isNull(_columnIndexOfPostedUserId) ? null : _stmt.getText(_columnIndexOfPostedUserId);
                    _result.setPostedUserId(_tmpPostedUserId);
                    String _tmpSharedUserId = _stmt.isNull(_columnIndexOfSharedUserId) ? null : _stmt.getText(_columnIndexOfSharedUserId);
                    _result.setSharedUserId(_tmpSharedUserId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setMetadata(_tmpMetadata);
                    int _tmpSharedCount = (int)_stmt.getLong(_columnIndexOfSharedCount);
                    _result.setSharedCount(_tmpSharedCount);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    int _tmpCommentCount = (int)_stmt.getLong(_columnIndexOfCommentCount);
                    _result.setCommentCount(_tmpCommentCount);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmpStructureType = _stmt.isNull(_columnIndexOfStructureType) ? null : _stmt.getText(_columnIndexOfStructureType);
                    _result.setStructureType(_tmpStructureType);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_3 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpPostDataType = _stmt.isNull(_columnIndexOfPostDataType) ? null : _stmt.getText(_columnIndexOfPostDataType);
                    _result.setPostDataType(_tmpPostDataType);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _result.setData(_tmpData);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfChildPostIds) ? null : _stmt.getText(_columnIndexOfChildPostIds);
                    List<String> _tmpChildPostIds = this.__stringListConverter.stringToStringList(_tmp_5);
                    _result.setChildPostIds(_tmpChildPostIds);
                    String _tmpFeedType = _stmt.isNull(_columnIndexOfFeedType) ? null : _stmt.getText(_columnIndexOfFeedType);
                    _result.setFeedType(_tmpFeedType);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                    _result.setMentionees(_tmpMentionees);
                    int _tmpImpression = (int)_stmt.getLong(_columnIndexOfImpression);
                    _result.setImpression(_tmpImpression);
                    int _tmpReach = (int)_stmt.getLong(_columnIndexOfReach);
                    _result.setReach(_tmpReach);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfHashtags) ? null : _stmt.getText(_columnIndexOfHashtags);
                    List<String> _tmpHashtags = this.__stringListConverter.stringToStringList(_tmp_7);
                    _result.setHashtags(_tmpHashtags);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_8);
                    _result.setPii(_tmpPii);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                PostEntity postEntity = _result;
                return postEntity;
            }
        });
    }

    @Override
    public Flowable<List<PostEntity>> observePostImpl(String postId) {
        String _sql = "SELECT * from post where post.postId IN (?)";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"post"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from post where post.postId IN (?)");){
                int _argIndex = 1;
                if (postId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, postId);
                }
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfParentPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentPostId");
                int _columnIndexOfPostedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postedUserId");
                int _columnIndexOfSharedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sharedUserId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfSharedCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sharedCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfCommentCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentCount");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfStructureType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"structureType");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPostDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postDataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfChildPostIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childPostIds");
                int _columnIndexOfFeedType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"feedType");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfImpression = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"impression");
                int _columnIndexOfReach = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reach");
                int _columnIndexOfHashtags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hashtags");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<PostEntity> _result = new ArrayList<PostEntity>();
                while (_stmt.step()) {
                    PostEntity _item = new PostEntity();
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _item.setPostId(_tmpPostId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    _item.setMid(_tmpMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item.setPath(_tmpPath);
                    String _tmpParentPostId = _stmt.isNull(_columnIndexOfParentPostId) ? null : _stmt.getText(_columnIndexOfParentPostId);
                    _item.setParentPostId(_tmpParentPostId);
                    String _tmpPostedUserId = _stmt.isNull(_columnIndexOfPostedUserId) ? null : _stmt.getText(_columnIndexOfPostedUserId);
                    _item.setPostedUserId(_tmpPostedUserId);
                    String _tmpSharedUserId = _stmt.isNull(_columnIndexOfSharedUserId) ? null : _stmt.getText(_columnIndexOfSharedUserId);
                    _item.setSharedUserId(_tmpSharedUserId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _item.setMetadata(_tmpMetadata);
                    int _tmpSharedCount = (int)_stmt.getLong(_columnIndexOfSharedCount);
                    _item.setSharedCount(_tmpSharedCount);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                    _item.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _item.setReactionCount(_tmpReactionCount);
                    int _tmpCommentCount = (int)_stmt.getLong(_columnIndexOfCommentCount);
                    _item.setCommentCount(_tmpCommentCount);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _item.setFlagCount(_tmpFlagCount);
                    String _tmpStructureType = _stmt.isNull(_columnIndexOfStructureType) ? null : _stmt.getText(_columnIndexOfStructureType);
                    _item.setStructureType(_tmpStructureType);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setEditedAt(_tmpEditedAt);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_3 != 0;
                    _item.setDeleted(_tmpIsDeleted);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _item.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _item.setTargetId(_tmpTargetId);
                    String _tmpPostDataType = _stmt.isNull(_columnIndexOfPostDataType) ? null : _stmt.getText(_columnIndexOfPostDataType);
                    _item.setPostDataType(_tmpPostDataType);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _item.setData(_tmpData);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfChildPostIds) ? null : _stmt.getText(_columnIndexOfChildPostIds);
                    List<String> _tmpChildPostIds = this.__stringListConverter.stringToStringList(_tmp_5);
                    _item.setChildPostIds(_tmpChildPostIds);
                    String _tmpFeedType = _stmt.isNull(_columnIndexOfFeedType) ? null : _stmt.getText(_columnIndexOfFeedType);
                    _item.setFeedType(_tmpFeedType);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                    _item.setMentionees(_tmpMentionees);
                    int _tmpImpression = (int)_stmt.getLong(_columnIndexOfImpression);
                    _item.setImpression(_tmpImpression);
                    int _tmpReach = (int)_stmt.getLong(_columnIndexOfReach);
                    _item.setReach(_tmpReach);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfHashtags) ? null : _stmt.getText(_columnIndexOfHashtags);
                    List<String> _tmpHashtags = this.__stringListConverter.stringToStringList(_tmp_7);
                    _item.setHashtags(_tmpHashtags);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_8);
                    _item.setPii(_tmpPii);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<PostEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<List<PostEntity>> getByPostIdsImpl(List<String> postIds) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from post where post.postId IN (");
        int _inputSize = postIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"post"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : postIds) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfParentPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentPostId");
                int _columnIndexOfPostedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postedUserId");
                int _columnIndexOfSharedUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sharedUserId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfSharedCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"sharedCount");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfCommentCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentCount");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfStructureType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"structureType");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfPostDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postDataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfChildPostIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childPostIds");
                int _columnIndexOfFeedType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"feedType");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfImpression = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"impression");
                int _columnIndexOfReach = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reach");
                int _columnIndexOfHashtags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hashtags");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<PostEntity> _result = new ArrayList<PostEntity>();
                while (_stmt.step()) {
                    PostEntity _item_1 = new PostEntity();
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _item_1.setPostId(_tmpPostId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    _item_1.setMid(_tmpMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item_1.setPath(_tmpPath);
                    String _tmpParentPostId = _stmt.isNull(_columnIndexOfParentPostId) ? null : _stmt.getText(_columnIndexOfParentPostId);
                    _item_1.setParentPostId(_tmpParentPostId);
                    String _tmpPostedUserId = _stmt.isNull(_columnIndexOfPostedUserId) ? null : _stmt.getText(_columnIndexOfPostedUserId);
                    _item_1.setPostedUserId(_tmpPostedUserId);
                    String _tmpSharedUserId = _stmt.isNull(_columnIndexOfSharedUserId) ? null : _stmt.getText(_columnIndexOfSharedUserId);
                    _item_1.setSharedUserId(_tmpSharedUserId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _item_1.setMetadata(_tmpMetadata);
                    int _tmpSharedCount = (int)_stmt.getLong(_columnIndexOfSharedCount);
                    _item_1.setSharedCount(_tmpSharedCount);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_1);
                    _item_1.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _item_1.setReactionCount(_tmpReactionCount);
                    int _tmpCommentCount = (int)_stmt.getLong(_columnIndexOfCommentCount);
                    _item_1.setCommentCount(_tmpCommentCount);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _item_1.setFlagCount(_tmpFlagCount);
                    String _tmpStructureType = _stmt.isNull(_columnIndexOfStructureType) ? null : _stmt.getText(_columnIndexOfStructureType);
                    _item_1.setStructureType(_tmpStructureType);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item_1.setEditedAt(_tmpEditedAt);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_3 != 0;
                    _item_1.setDeleted(_tmpIsDeleted);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _item_1.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _item_1.setTargetId(_tmpTargetId);
                    String _tmpPostDataType = _stmt.isNull(_columnIndexOfPostDataType) ? null : _stmt.getText(_columnIndexOfPostDataType);
                    _item_1.setPostDataType(_tmpPostDataType);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _item_1.setData(_tmpData);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfChildPostIds) ? null : _stmt.getText(_columnIndexOfChildPostIds);
                    List<String> _tmpChildPostIds = this.__stringListConverter.stringToStringList(_tmp_5);
                    _item_1.setChildPostIds(_tmpChildPostIds);
                    String _tmpFeedType = _stmt.isNull(_columnIndexOfFeedType) ? null : _stmt.getText(_columnIndexOfFeedType);
                    _item_1.setFeedType(_tmpFeedType);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                    _item_1.setMentionees(_tmpMentionees);
                    int _tmpImpression = (int)_stmt.getLong(_columnIndexOfImpression);
                    _item_1.setImpression(_tmpImpression);
                    int _tmpReach = (int)_stmt.getLong(_columnIndexOfReach);
                    _item_1.setReach(_tmpReach);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfHashtags) ? null : _stmt.getText(_columnIndexOfHashtags);
                    List<String> _tmpHashtags = this.__stringListConverter.stringToStringList(_tmp_7);
                    _item_1.setHashtags(_tmpHashtags);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_8);
                    _item_1.setPii(_tmpPii);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<PostEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from post";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from post");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public Completable deleteById(String postId) {
        String _sql = "DELETE from post where parentPostId = ? or postId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from post where parentPostId = ? or postId = ?");){
                int _argIndex = 1;
                if (postId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, postId);
                }
                _argIndex = 2;
                if (postId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, postId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public void incrementCommentCount(String postId) {
        String _sql = "UPDATE post set commentCount = commentCount + 1 where postId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE post set commentCount = commentCount + 1 where postId = ?");){
                int _argIndex = 1;
                if (postId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, postId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void decrementCommentCount(String postId) {
        String _sql = "UPDATE post set commentCount = MAX(commentCount - 1, 0)  where postId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE post set commentCount = MAX(commentCount - 1, 0)  where postId = ?");){
                int _argIndex = 1;
                if (postId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, postId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void updatePost(String postId) {
        String _sql = "UPDATE post set postId = postId where postId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE post set postId = postId where postId = ?");){
                int _argIndex = 1;
                if (postId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, postId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void notifyPostByTarget(String targetType, String targetId) {
        String _sql = "UPDATE post set postId = postId where targetType = ? and targetId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE post set postId = postId where targetType = ? and targetId = ?");){
                int _argIndex = 1;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetType);
                }
                _argIndex = 2;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public Completable updateDeletedImpl(String postId, boolean isDeleted) {
        String _sql = "UPDATE post SET isDeleted = ? WHERE postId = ? or parentPostId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE post SET isDeleted = ? WHERE postId = ? or parentPostId = ?");){
                int _argIndex = 1;
                int _tmp = isDeleted ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                if (postId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, postId);
                }
                _argIndex = 3;
                if (postId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, postId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public void updateFeedTypeImpl(String postId, String feedType) {
        String _sql = "UPDATE post SET feedType = ? WHERE postId = ? ";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE post SET feedType = ? WHERE postId = ? ");){
                int _argIndex = 1;
                if (feedType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, feedType);
                }
                _argIndex = 2;
                if (postId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, postId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public Completable invalidateChildPosts(String postId, List<String> childPostIds) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("DELETE from post where parentPostId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and postId not in (");
        int _inputSize = childPostIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                if (postId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, postId);
                }
                _argIndex = 2;
                for (String _item : childPostIds) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

