/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.chat.member.search;

import androidx.paging.PagingData;
import com.amity.socialcloud.sdk.api.chat.member.query.AmityChannelMembership;
import com.amity.socialcloud.sdk.chat.domain.channel.member.SearchChannelMembershipPagingSourceUseCase;
import com.amity.socialcloud.sdk.model.chat.member.AmityChannelMember;
import com.amity.socialcloud.sdk.model.core.role.AmityRoles;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B9\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/amity/socialcloud/sdk/api/chat/member/search/AmityChannelMemberSearch;", "", "channelId", "", "roles", "Lcom/amity/socialcloud/sdk/model/core/role/AmityRoles;", "memberships", "", "Lcom/amity/socialcloud/sdk/api/chat/member/query/AmityChannelMembership;", "keyword", "isDeleted", "", "<init>", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/core/role/AmityRoles;Ljava/util/List;Ljava/lang/String;Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "query", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagingData;", "Lcom/amity/socialcloud/sdk/model/chat/member/AmityChannelMember;", "Builder", "amity-sdk_release"})
public final class AmityChannelMemberSearch {
    @NotNull
    private final String channelId;
    @NotNull
    private final AmityRoles roles;
    @NotNull
    private final List<AmityChannelMembership> memberships;
    @NotNull
    private final String keyword;
    @Nullable
    private final Boolean isDeleted;

    public AmityChannelMemberSearch(@NotNull String channelId, @NotNull AmityRoles roles, @NotNull List<? extends AmityChannelMembership> memberships, @NotNull String keyword, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter(memberships, (String)"memberships");
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        this.channelId = channelId;
        this.roles = roles;
        this.memberships = memberships;
        this.keyword = keyword;
        this.isDeleted = isDeleted;
    }

    @NotNull
    public final Flowable<PagingData<AmityChannelMember>> query() {
        return new SearchChannelMembershipPagingSourceUseCase().execute(this.channelId, this.memberships, this.roles, this.keyword, this.isDeleted);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u000f\u001a\u00020\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0014\u0010\n\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\rJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0006J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/amity/socialcloud/sdk/api/chat/member/search/AmityChannelMemberSearch$Builder;", "", "channelId", "", "keyword", "isDeleted", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "roles", "Lcom/amity/socialcloud/sdk/model/core/role/AmityRoles;", "memberships", "", "Lcom/amity/socialcloud/sdk/api/chat/member/query/AmityChannelMembership;", "membershipFilter", "channelMembership", "includeDeleted", "build", "Lcom/amity/socialcloud/sdk/api/chat/member/search/AmityChannelMemberSearch;", "amity-sdk_release"})
    public static final class Builder {
        @NotNull
        private String channelId;
        @NotNull
        private String keyword;
        @Nullable
        private Boolean isDeleted;
        @NotNull
        private AmityRoles roles;
        @NotNull
        private List<? extends AmityChannelMembership> memberships;

        public Builder(@NotNull String channelId, @NotNull String keyword, @Nullable Boolean isDeleted) {
            Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            this.channelId = channelId;
            this.keyword = keyword;
            this.isDeleted = isDeleted;
            this.roles = new AmityRoles();
            this.memberships = CollectionsKt.listOf((Object)((Object)AmityChannelMembership.MEMBER));
        }

        public /* synthetic */ Builder(String string, String string2, Boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = null;
            }
            this(string, string2, bl);
        }

        @NotNull
        public final Builder membershipFilter(@NotNull List<? extends AmityChannelMembership> channelMembership) {
            Builder builder;
            Intrinsics.checkNotNullParameter(channelMembership, (String)"channelMembership");
            Builder $this$membershipFilter_u24lambda_u240 = builder = this;
            boolean bl = false;
            if (!((Collection)channelMembership).isEmpty()) {
                $this$membershipFilter_u24lambda_u240.memberships = channelMembership;
            }
            return builder;
        }

        @NotNull
        public final Builder roles(@NotNull List<String> roles) {
            Builder builder;
            Intrinsics.checkNotNullParameter(roles, (String)"roles");
            Builder $this$roles_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$roles_u24lambda_u241.roles = new AmityRoles(roles);
            return builder;
        }

        @NotNull
        public final Builder includeDeleted(boolean includeDeleted) {
            Builder builder;
            Builder $this$includeDeleted_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$includeDeleted_u24lambda_u242.isDeleted = includeDeleted ? null : Boolean.valueOf(false);
            return builder;
        }

        @NotNull
        public final AmityChannelMemberSearch build() {
            return new AmityChannelMemberSearch(this.channelId, this.roles, this.memberships, this.keyword, this.isDeleted);
        }
    }
}

