package com.ekoapp.ekosdk.internal.usecase.post

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.core.data.pin.PinRepository
import com.amity.socialcloud.sdk.model.core.pin.AmityPinSortByOptions
import com.amity.socialcloud.sdk.model.core.pin.AmityPinnedPost
import com.amity.socialcloud.sdk.social.domain.post.PinnedPostComposerUseCase
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class PinnedPostQueryUseCase {
	
	fun execute(
		communityId: String,
		placement: String? = null,
		includeMixedStructure: Boolean,
		sortByOptions: AmityPinSortByOptions,
	): Flowable<PagingData<AmityPinnedPost>> {
		return PinRepository().getPinnedPostPagingData(
			targetId = communityId,
			targetType = "community",
			placement = placement,
			includeMixedStructure = includeMixedStructure,
			sortByOptions = sortByOptions
		).map { pagingData ->
				pagingData.map(Executors.newSingleThreadExecutor()) { post ->
					PinnedPostComposerUseCase().execute(post)
				}
			}
	}
	
}