package com.amity.socialcloud.sdk.social.data.post.paging

import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator

internal class PinKeyCreator(
	val targetId: String,
	val targetType: String,
	val placement: String? = null,
	val includeMixedStructure: Boolean,
) : DynamicQueryStreamKeyCreator {
	
	override fun toMap(): Map<String, Any> {
		return mapOf(
			"targetId" to targetId,
			"targetType" to targetType,
			"placement" to (placement ?: ""),
			"includeMixedStructure" to (includeMixedStructure),
		)
	}
	
	override fun getFilterQuery(): String {
		var filterQuery = " pin.targetId = '$targetId' "
		
		//structureType filter - exclude mixed structure posts when includeMixedStructure is false
		if (!includeMixedStructure) {
			filterQuery += " and (post.structureType != 'mixed' OR post.structureType IS NULL)"
		}
		
		return filterQuery
	}
}