package com.amity.socialcloud.sdk.core.data.invitation

import com.amity.socialcloud.sdk.core.data.reaction.paging.InvitationMediator.Target
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitationType
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.InvitationsQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.CreateInvitationsRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class InvitationRemoteDataStore {

    fun getInvitations(
        type: AmityInvitationType,
        target: Target,
        limit: Int? = null,
        token: String? = null
    ): Single<InvitationsQueryDto> {
        return AmityHttpClient.get(InvitationApi::class).flatMap {
            it.queryInvitations(
                type = type.value,
                targetId = target.id,
                targetType = target.type,
                limit = limit,
                token = token,
            )
        }
    }

    fun getMyInvitations(
        type: AmityInvitationType,
        target: Target? = null,
        limit: Int? = null,
        token: String? = null
    ): Single<InvitationsQueryDto> {
        return AmityHttpClient.get(InvitationApi::class).flatMap {
            it.queryMyInvitations(
                type = type.value,
                targetId = target?.id,
                targetType = target?.type,
                limit = limit,
                token = token,
            )
        }
    }

    fun createInvitations(
        request: CreateInvitationsRequest,
    ): Single<InvitationsQueryDto> {
        return AmityHttpClient.get(InvitationApi::class).flatMap {
            it.createInvitation(request)
        }
    }

    fun acceptInvitations(
        invitationId: String,
    ): Single<JsonObject> {
        return AmityHttpClient.get(InvitationApi::class).flatMap {
            it.acceptInvitation(invitationId)
        }
    }

    fun rejectInvitations(
        invitationId: String,
    ): Single<JsonObject> {
        return AmityHttpClient.get(InvitationApi::class).flatMap {
            it.rejectInvitation(invitationId)
        }
    }

    fun cancelInvitations(
        invitationId: String,
    ): Single<JsonObject> {
        return AmityHttpClient.get(InvitationApi::class).flatMap {
            it.cancelInvitation(invitationId)
        }
    }

}