package com.amity.socialcloud.sdk.chat.domain.marker.reader

import com.amity.socialcloud.sdk.api.core.events.AmityTopicSubscription
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRepository
import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.model.core.events.AmityTopic
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single

internal class SubscribeToSubChannelMarkerTopicUseCase {
	
	fun execute(subChannelId: String, channelId: String? = null): Completable {
		return if (channelId == null) {
			SubChannelRepository().getSubChannel(subChannelId).map {
				it.getChannelId()
			}
		} else {
			Single.just(channelId)
		}.flatMapCompletable { channelId ->
			AmityTopicSubscription(AmityTopic.SUB_CHANNEL_MARKER(subChannelId, channelId))
					.subscribeTopic()
		}.onErrorComplete()
	}
	
}