/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.session;

import com.amity.socialcloud.sdk.core.domain.session.GetCurrentAccountUseCase;
import com.amity.socialcloud.sdk.core.domain.session.RenewTokenUseCase;
import com.amity.socialcloud.sdk.core.session.AccessTokenRenewal;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BT\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012!\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\b0\n\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0017\u001a\u00020\bJ,\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010\u001f\u001a\u00020\bH\u0016J\u0018\u0010 \u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\"\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R)\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/amity/socialcloud/sdk/core/session/AccessTokenRenewalImpl;", "Lcom/amity/socialcloud/sdk/core/session/AccessTokenRenewal;", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "onRenewTokenSuccess", "Lkotlin/Function0;", "", "onRenewTokenFailed", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "throwable", "onUnableToRetrieveAuthToken", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "invalidated", "", "getInvalidated", "()Z", "setInvalidated", "(Z)V", "invalidate", "refreshToken", "Lio/reactivex/rxjava3/core/Completable;", "authToken", "", "authSignature", "authSignatureExpiresAt", "Lorg/joda/time/DateTime;", "renew", "renewWithAuthSignature", "renewWithAuthToken", "unableToRetrieveAuthToken", "amity-sdk_release"})
public final class AccessTokenRenewalImpl
implements AccessTokenRenewal {
    @NotNull
    private final AppEventBus appEventBus;
    @NotNull
    private final SessionLifeCycleEventBus sessionLifeCycleEventBus;
    @NotNull
    private final Function0<Unit> onRenewTokenSuccess;
    @NotNull
    private final Function1<Throwable, Unit> onRenewTokenFailed;
    @NotNull
    private final Function0<Unit> onUnableToRetrieveAuthToken;
    private boolean invalidated;

    public AccessTokenRenewalImpl(@NotNull AppEventBus appEventBus, @NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull Function0<Unit> onRenewTokenSuccess, @NotNull Function1<? super Throwable, Unit> onRenewTokenFailed, @NotNull Function0<Unit> onUnableToRetrieveAuthToken) {
        Intrinsics.checkNotNullParameter((Object)appEventBus, (String)"appEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter(onRenewTokenSuccess, (String)"onRenewTokenSuccess");
        Intrinsics.checkNotNullParameter(onRenewTokenFailed, (String)"onRenewTokenFailed");
        Intrinsics.checkNotNullParameter(onUnableToRetrieveAuthToken, (String)"onUnableToRetrieveAuthToken");
        this.appEventBus = appEventBus;
        this.sessionLifeCycleEventBus = sessionLifeCycleEventBus;
        this.onRenewTokenSuccess = onRenewTokenSuccess;
        this.onRenewTokenFailed = onRenewTokenFailed;
        this.onUnableToRetrieveAuthToken = onUnableToRetrieveAuthToken;
    }

    public final boolean getInvalidated() {
        return this.invalidated;
    }

    public final void setInvalidated(boolean bl) {
        this.invalidated = bl;
    }

    @Override
    public void renew() {
        if (this.invalidated) {
            return;
        }
        this.invalidate();
        AccessTokenRenewalImpl.refreshToken$default(this, null, null, null, 7, null).doOnComplete(() -> AccessTokenRenewalImpl.renew$lambda$0(this)).doOnError(new Consumer(this){
            final /* synthetic */ AccessTokenRenewalImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AccessTokenRenewalImpl.access$getOnRenewTokenFailed$p(this.this$0).invoke((Object)it);
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    @Override
    public void renewWithAuthToken(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        if (this.invalidated) {
            return;
        }
        this.invalidate();
        AccessTokenRenewalImpl.refreshToken$default(this, authToken, null, null, 6, null).doOnComplete(() -> AccessTokenRenewalImpl.renewWithAuthToken$lambda$1(this)).doOnError(new Consumer(this){
            final /* synthetic */ AccessTokenRenewalImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AccessTokenRenewalImpl.access$getOnRenewTokenFailed$p(this.this$0).invoke((Object)it);
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    @Override
    public void renewWithAuthSignature(@NotNull String authSignature, @NotNull DateTime authSignatureExpiresAt) {
        Intrinsics.checkNotNullParameter((Object)authSignature, (String)"authSignature");
        Intrinsics.checkNotNullParameter((Object)authSignatureExpiresAt, (String)"authSignatureExpiresAt");
        if (this.invalidated) {
            return;
        }
        this.invalidate();
        AccessTokenRenewalImpl.refreshToken$default(this, null, null, null, 7, null).doOnComplete(() -> AccessTokenRenewalImpl.renewWithAuthSignature$lambda$2(this)).doOnError(new Consumer(this){
            final /* synthetic */ AccessTokenRenewalImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AccessTokenRenewalImpl.access$getOnRenewTokenFailed$p(this.this$0).invoke((Object)it);
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    @Override
    public void unableToRetrieveAuthToken() {
        this.onUnableToRetrieveAuthToken.invoke();
    }

    public final void invalidate() {
        this.invalidated = true;
    }

    private final Completable refreshToken(String authToken, String authSignature, DateTime authSignatureExpiresAt) {
        Completable completable = new GetCurrentAccountUseCase().execute().flatMap(new Function(this, authToken, authSignature, authSignatureExpiresAt){
            final /* synthetic */ AccessTokenRenewalImpl this$0;
            final /* synthetic */ String $authToken;
            final /* synthetic */ String $authSignature;
            final /* synthetic */ DateTime $authSignatureExpiresAt;
            {
                this.this$0 = $receiver;
                this.$authToken = $authToken;
                this.$authSignature = $authSignature;
                this.$authSignatureExpiresAt = $authSignatureExpiresAt;
            }

            @NotNull
            public final SingleSource<? extends EkoAccount> apply(@NotNull EkoAccount it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (SingleSource)new RenewTokenUseCase().execute(AccessTokenRenewalImpl.access$getAppEventBus$p(this.this$0), AccessTokenRenewalImpl.access$getSessionLifeCycleEventBus$p(this.this$0), it, this.$authToken, this.$authSignature, this.$authSignatureExpiresAt);
            }
        }).subscribeOn(Schedulers.io()).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"private fun refreshToken\u2026   .ignoreElement()\n    }");
        return completable;
    }

    static /* synthetic */ Completable refreshToken$default(AccessTokenRenewalImpl accessTokenRenewalImpl, String string, String string2, DateTime dateTime, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            dateTime = null;
        }
        return accessTokenRenewalImpl.refreshToken(string, string2, dateTime);
    }

    private static final void renew$lambda$0(AccessTokenRenewalImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onRenewTokenSuccess.invoke();
    }

    private static final void renewWithAuthToken$lambda$1(AccessTokenRenewalImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onRenewTokenSuccess.invoke();
    }

    private static final void renewWithAuthSignature$lambda$2(AccessTokenRenewalImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onRenewTokenSuccess.invoke();
    }

    public static final /* synthetic */ Function1 access$getOnRenewTokenFailed$p(AccessTokenRenewalImpl $this) {
        return $this.onRenewTokenFailed;
    }

    public static final /* synthetic */ AppEventBus access$getAppEventBus$p(AccessTokenRenewalImpl $this) {
        return $this.appEventBus;
    }

    public static final /* synthetic */ SessionLifeCycleEventBus access$getSessionLifeCycleEventBus$p(AccessTokenRenewalImpl $this) {
        return $this.sessionLifeCycleEventBus;
    }
}

