package com.amity.socialcloud.sdk.social.data.poll

import com.amity.socialcloud.sdk.model.social.poll.AmityPollAnswer
import com.google.gson.JsonArray
import com.google.gson.JsonObject

internal class PollRepositoryHelper {

    fun convertAnswersToJsonArray(answers: List<AmityPollAnswer.Data>): JsonArray {
        return JsonArray().apply {
            answers.forEach { pollData ->
                when (pollData) {
                    is AmityPollAnswer.Data.TEXT -> {
                        add(JsonObject().apply {
                            addProperty("dataType", pollData.apiKey)
                            addProperty("data", pollData.data)
                        })
                    }

                    is AmityPollAnswer.Data.IMAGE -> {
                        add(JsonObject().apply {
                            addProperty("dataType", pollData.apiKey)
                            addProperty("data", pollData.data)
                            addProperty("fileId", pollData.fileId)
                        })
                    }
                    // UNKNOWN case is not explicitly handled as per existing logic
                    is AmityPollAnswer.Data.UNKNOWN -> {
                        // Optionally handle UNKNOWN or log, though current code doesn't
                    }
                }
            }
        }
    }
}