package com.amity.socialcloud.sdk.video.domain.stream

import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamSessionEntity
import com.amity.socialcloud.sdk.video.data.session.StreamSessionRepository
import com.amity.socialcloud.sdk.video.data.stream.StreamSessionSyncState
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers
import java.util.concurrent.TimeUnit

private const val MIN_JITTER = 5
private const val MAX_JITTER = 30

internal class SyncPendingSessionUseCase {

    fun execute() {
        jitter().flatMapCompletable {
            Completable.fromAction { StreamSessionRepository().resetSyncState() }
                    .andThen(queryPendingSyncSession())
                    .flatMapCompletable { sendToSever(it) }
        }.subscribeOn(Schedulers.io())
                .subscribe()

    }

    private fun sendToSever(streamSessions: List<EkoStreamSessionEntity>): Completable {
        return SendStreamSessionUseCase().execute(streamSessions, true)
                .subscribeOn(Schedulers.io())
    }

    private fun jitter(): Single<Long> {
        val jitter = (MIN_JITTER..MAX_JITTER).random().toLong()
        return Single.timer(jitter, TimeUnit.SECONDS, Schedulers.io())
    }

    private fun queryPendingSyncSession(): Single<List<EkoStreamSessionEntity>> {
        return StreamSessionRepository().getStreamSessionCollection(arrayOf(StreamSessionSyncState.PENDING)).firstOrError()
    }
}