/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.util;

import com.amity.socialcloud.sdk.helper.core.mention.AmityMentionMetadata;
import com.amity.socialcloud.sdk.helper.core.mention.AmityMentionMetadataGetter;
import com.ekoapp.ekosdk.internal.api.dto.EkoPiiDto;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0014\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J@\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001bH\u0002\u00a8\u0006\""}, d2={"Lcom/ekoapp/ekosdk/internal/util/PIIUtils;", "", "<init>", "()V", "parsePIIData", "", "LAmityPII;", "piiArray", "Lcom/google/gson/JsonArray;", "convertDtosToJsonArray", "piiDtos", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoPiiDto;", "parsePIIDataFromArray", "parseCategoryFromString", "LAmityPII$Category;", "categoryString", "", "redactPIIFromText", "originalText", "piiList", "mentionJson", "Lcom/google/gson/JsonObject;", "piiCategories", "replaceChar", "", "extractMentionRangesFromMetadata", "Lkotlin/Pair;", "", "rangesOverlap", "", "start1", "end1", "start2", "end2", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nPIIUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PIIUtils.kt\ncom/ekoapp/ekosdk/internal/util/PIIUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1869#2,2:191\n1617#2,9:193\n1869#2:202\n1870#2:204\n1626#2:205\n1056#2:206\n1869#2,2:207\n1869#2,2:209\n1#3:203\n*S KotlinDebug\n*F\n+ 1 PIIUtils.kt\ncom/ekoapp/ekosdk/internal/util/PIIUtils\n*L\n28#1:191,2\n45#1:193,9\n45#1:202\n45#1:204\n45#1:205\n97#1:206\n153#1:207,2\n162#1:209,2\n45#1:203\n*E\n"})
public final class PIIUtils {
    @NotNull
    public static final PIIUtils INSTANCE = new PIIUtils();

    private PIIUtils() {
    }

    @NotNull
    public final List<AmityPII> parsePIIData(@Nullable JsonArray piiArray) {
        if (piiArray == null) {
            return CollectionsKt.emptyList();
        }
        return this.parsePIIDataFromArray(piiArray);
    }

    @NotNull
    public final JsonArray convertDtosToJsonArray(@NotNull List<EkoPiiDto> piiDtos) {
        Intrinsics.checkNotNullParameter(piiDtos, (String)"piiDtos");
        JsonArray piiArray = new JsonArray();
        Iterable $this$forEach$iv = piiDtos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonObject jsonObject;
            EkoPiiDto piiDto = (EkoPiiDto)element$iv;
            boolean bl = false;
            JsonObject $this$convertDtosToJsonArray_u24lambda_u241_u24lambda_u240 = jsonObject = new JsonObject();
            boolean bl2 = false;
            $this$convertDtosToJsonArray_u24lambda_u241_u24lambda_u240.addProperty("category", piiDto.getCategory());
            $this$convertDtosToJsonArray_u24lambda_u241_u24lambda_u240.addProperty("offset", (Number)piiDto.getOffset());
            $this$convertDtosToJsonArray_u24lambda_u241_u24lambda_u240.addProperty("length", (Number)piiDto.getLength());
            $this$convertDtosToJsonArray_u24lambda_u241_u24lambda_u240.addProperty("confidenceScore", (Number)piiDto.getConfidenceScore());
            JsonObject piiObject = jsonObject;
            piiArray.add((JsonElement)piiObject);
        }
        return piiArray;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AmityPII> parsePIIDataFromArray(JsonArray piiArray) {
        List list;
        try {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)piiArray;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                AmityPII amityPII;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                JsonElement element = (JsonElement)element$iv$iv;
                boolean bl2 = false;
                JsonObject piiObject = element.getAsJsonObject();
                Object object = piiObject.get("category");
                if (object == null || (object = object.getAsString()) == null) {
                    amityPII = null;
                } else {
                    Object category = object;
                    JsonElement jsonElement = piiObject.get("offset");
                    if (jsonElement == null) {
                        amityPII = null;
                    } else {
                        int offset = jsonElement.getAsInt();
                        JsonElement jsonElement2 = piiObject.get("length");
                        if (jsonElement2 == null) {
                            amityPII = null;
                        } else {
                            int length = jsonElement2.getAsInt();
                            JsonElement jsonElement3 = piiObject.get("confidenceScore");
                            double confidence = jsonElement3 != null ? jsonElement3.getAsDouble() : 0.0;
                            AmityPII.Category categoryEnum = INSTANCE.parseCategoryFromString((String)category);
                            amityPII = new AmityPII(offset, length, confidence, categoryEnum);
                        }
                    }
                }
                if (amityPII == null) continue;
                AmityPII it$iv$iv = amityPII;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        catch (Exception e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final AmityPII.Category parseCategoryFromString(String categoryString) {
        return switch (categoryString) {
            case "Email" -> AmityPII.Category.EMAIL.INSTANCE;
            case "PhoneNumber" -> AmityPII.Category.PHONE_NUMBER.INSTANCE;
            case "IPAddress" -> AmityPII.Category.IP_ADDRESS.INSTANCE;
            case "Address" -> AmityPII.Category.ADDRESS.INSTANCE;
            case "PassportNumber" -> AmityPII.Category.PASSPORT_NUMBER.INSTANCE;
            default -> new AmityPII.Category.OTHERS(categoryString);
        };
    }

    @NotNull
    public final String redactPIIFromText(@NotNull String originalText, @NotNull List<AmityPII> piiList, @Nullable JsonObject mentionJson, @NotNull List<? extends AmityPII.Category> piiCategories, char replaceChar) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        Intrinsics.checkNotNullParameter(piiList, (String)"piiList");
        Intrinsics.checkNotNullParameter(piiCategories, (String)"piiCategories");
        char[] cArray = originalText.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] mutableText = cArray;
        Iterable $this$sortedBy$iv = piiList;
        boolean $i$f$sortedBy = false;
        List sortedPIIList = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AmityPII it = (AmityPII)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOffset());
                it = (AmityPII)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOffset()));
            }
        });
        List<Pair<Integer, Integer>> mentionRangesList = this.extractMentionRangesFromMetadata(mentionJson);
        for (AmityPII pii : sortedPIIList) {
            if (!((Collection)piiCategories).isEmpty() && !piiCategories.contains(pii.getCategory())) continue;
            int piiStart = pii.getOffset();
            int piiEnd = pii.getOffset() + pii.getLength();
            boolean isOverlapping = false;
            for (Pair<Integer, Integer> mentionRange : mentionRangesList) {
                if (!this.rangesOverlap(piiStart, piiEnd, ((Number)mentionRange.getFirst()).intValue(), ((Number)mentionRange.getSecond()).intValue())) continue;
                isOverlapping = true;
                break;
            }
            if (isOverlapping) continue;
            for (int i = piiStart; i < piiEnd; ++i) {
                if (i >= mutableText.length) continue;
                mutableText[i] = replaceChar;
            }
        }
        return new String(mutableText);
    }

    public static /* synthetic */ String redactPIIFromText$default(PIIUtils pIIUtils, String string, List list, JsonObject jsonObject, List list2, char c, int n, Object object) {
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            c = (char)42;
        }
        return pIIUtils.redactPIIFromText(string, list, jsonObject, list2, c);
    }

    @NotNull
    public final List<Pair<Integer, Integer>> extractMentionRangesFromMetadata(@Nullable JsonObject mentionJson) {
        List list;
        if (mentionJson == null) {
            return CollectionsKt.emptyList();
        }
        try {
            int length;
            int startIndex;
            AmityMentionMetadataGetter mentionMetadataGetter = new AmityMentionMetadataGetter(mentionJson);
            List ranges = new ArrayList();
            Iterable $this$forEach$iv = mentionMetadataGetter.getMentionedUsers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AmityMentionMetadata.USER userMention = (AmityMentionMetadata.USER)element$iv;
                boolean bl = false;
                startIndex = userMention.getIndex();
                length = userMention.getLength();
                if (startIndex < 0 || length <= 0) continue;
                ranges.add(new Pair((Object)startIndex, (Object)(startIndex + length)));
            }
            $this$forEach$iv = mentionMetadataGetter.getMentionedChannels();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AmityMentionMetadata.CHANNEL channelMention = (AmityMentionMetadata.CHANNEL)element$iv;
                boolean bl = false;
                startIndex = channelMention.getIndex();
                length = channelMention.getLength();
                if (startIndex < 0 || length <= 0) continue;
                ranges.add(new Pair((Object)startIndex, (Object)(startIndex + length)));
            }
            list = ranges;
        }
        catch (Exception e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final boolean rangesOverlap(int start1, int end1, int start2, int end2) {
        return start1 < end2 && start2 < end1;
    }
}

