/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.MessagePreviewDao;
import com.ekoapp.ekosdk.internal.data.model.MessagePreviewEntity;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class MessagePreviewDao_Impl
extends MessagePreviewDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<MessagePreviewEntity> __insertAdapterOfMessagePreviewEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<MessagePreviewEntity> __deleteAdapterOfMessagePreviewEntity;
    private final EntityDeleteOrUpdateAdapter<MessagePreviewEntity> __updateAdapterOfMessagePreviewEntity;

    public MessagePreviewDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfMessagePreviewEntity = new EntityInsertAdapter<MessagePreviewEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `message_preview` (`messagePreviewId`,`dataType`,`data`,`channelId`,`subChannelId`,`subChannelName`,`subChannelUpdatedAt`,`creatorId`,`isDeleted`,`segment`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull MessagePreviewEntity entity) {
                if (entity.getMessagePreviewId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getMessagePreviewId());
                }
                if (entity.getDataType() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getDataType());
                }
                String _tmp = MessagePreviewDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getData());
                if (_tmp == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp);
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getChannelId());
                }
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getSubChannelId());
                }
                if (entity.getSubChannelName() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getSubChannelName());
                }
                String _tmp_1 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getSubChannelUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_1);
                }
                if (entity.getCreatorId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getCreatorId());
                }
                int _tmp_2 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(9, (long)_tmp_2);
                statement.bindLong(10, (long)entity.getSegment());
                String _tmp_3 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_3);
                }
                String _tmp_4 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_4);
                }
                String _tmp_5 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_5 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_5);
                }
            }
        };
        this.__deleteAdapterOfMessagePreviewEntity = new EntityDeleteOrUpdateAdapter<MessagePreviewEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `message_preview` WHERE `subChannelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull MessagePreviewEntity entity) {
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSubChannelId());
                }
            }
        };
        this.__updateAdapterOfMessagePreviewEntity = new EntityDeleteOrUpdateAdapter<MessagePreviewEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `message_preview` SET `messagePreviewId` = ?,`dataType` = ?,`data` = ?,`channelId` = ?,`subChannelId` = ?,`subChannelName` = ?,`subChannelUpdatedAt` = ?,`creatorId` = ?,`isDeleted` = ?,`segment` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `subChannelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull MessagePreviewEntity entity) {
                if (entity.getMessagePreviewId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getMessagePreviewId());
                }
                if (entity.getDataType() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getDataType());
                }
                String _tmp = MessagePreviewDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getData());
                if (_tmp == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp);
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getChannelId());
                }
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getSubChannelId());
                }
                if (entity.getSubChannelName() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getSubChannelName());
                }
                String _tmp_1 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getSubChannelUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_1);
                }
                if (entity.getCreatorId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getCreatorId());
                }
                int _tmp_2 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(9, (long)_tmp_2);
                statement.bindLong(10, (long)entity.getSegment());
                String _tmp_3 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_3);
                }
                String _tmp_4 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_4);
                }
                String _tmp_5 = MessagePreviewDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_5 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_5);
                }
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, entity.getSubChannelId());
                }
            }
        };
    }

    @Override
    public void insertImpl(MessagePreviewEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfMessagePreviewEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends MessagePreviewEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfMessagePreviewEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(MessagePreviewEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfMessagePreviewEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends MessagePreviewEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfMessagePreviewEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(MessagePreviewEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfMessagePreviewEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(MessagePreviewEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            MessagePreviewDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends MessagePreviewEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            MessagePreviewDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(MessagePreviewEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            MessagePreviewDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public MessagePreviewEntity getByIdNow(String subChannelId) {
        String _sql = "SELECT * from message_preview where subChannelId = ? LIMIT 1";
        return (MessagePreviewEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from message_preview where subChannelId = ? LIMIT 1");){
                MessagePreviewEntity _result;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                int _columnIndexOfMessagePreviewId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfSubChannelName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelName");
                int _columnIndexOfSubChannelUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelUpdatedAt");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segment");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpMessagePreviewId = _stmt.isNull(_columnIndexOfMessagePreviewId) ? null : _stmt.getText(_columnIndexOfMessagePreviewId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    String _tmpSubChannelName = _stmt.isNull(_columnIndexOfSubChannelName) ? null : _stmt.getText(_columnIndexOfSubChannelName);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfSubChannelUpdatedAt) ? null : _stmt.getText(_columnIndexOfSubChannelUpdatedAt);
                    DateTime _tmpSubChannelUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_2 != 0;
                    int _tmpSegment = (int)_stmt.getLong(_columnIndexOfSegment);
                    _result = new MessagePreviewEntity(_tmpMessagePreviewId, _tmpDataType, _tmpData, _tmpChannelId, _tmpSubChannelId, _tmpSubChannelName, _tmpSubChannelUpdatedAt, _tmpCreatorId, _tmpIsDeleted, _tmpSegment);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                MessagePreviewEntity messagePreviewEntity = _result;
                return messagePreviewEntity;
            }
        });
    }

    @Override
    public List<MessagePreviewEntity> getByIdsNow(List<String> subChannelIds) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from message_preview where message_preview.subChannelId IN (");
        int _inputSize = subChannelIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : subChannelIds) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfMessagePreviewId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfSubChannelName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelName");
                int _columnIndexOfSubChannelUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelUpdatedAt");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segment");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<MessagePreviewEntity> _result = new ArrayList<MessagePreviewEntity>();
                while (_stmt.step()) {
                    String _tmpMessagePreviewId = _stmt.isNull(_columnIndexOfMessagePreviewId) ? null : _stmt.getText(_columnIndexOfMessagePreviewId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    String _tmpSubChannelName = _stmt.isNull(_columnIndexOfSubChannelName) ? null : _stmt.getText(_columnIndexOfSubChannelName);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfSubChannelUpdatedAt) ? null : _stmt.getText(_columnIndexOfSubChannelUpdatedAt);
                    DateTime _tmpSubChannelUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_2 != 0;
                    int _tmpSegment = (int)_stmt.getLong(_columnIndexOfSegment);
                    MessagePreviewEntity _item_1 = new MessagePreviewEntity(_tmpMessagePreviewId, _tmpDataType, _tmpData, _tmpChannelId, _tmpSubChannelId, _tmpSubChannelName, _tmpSubChannelUpdatedAt, _tmpCreatorId, _tmpIsDeleted, _tmpSegment);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<MessagePreviewEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<MessagePreviewEntity> getById(String messagePreviewId) {
        String _sql = "SELECT * from message_preview where messagePreviewId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message_preview"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from message_preview where messagePreviewId = ? LIMIT 1");){
                MessagePreviewEntity _result;
                int _argIndex = 1;
                if (messagePreviewId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messagePreviewId);
                }
                int _columnIndexOfMessagePreviewId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfSubChannelName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelName");
                int _columnIndexOfSubChannelUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelUpdatedAt");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segment");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpMessagePreviewId = _stmt.isNull(_columnIndexOfMessagePreviewId) ? null : _stmt.getText(_columnIndexOfMessagePreviewId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    String _tmpSubChannelName = _stmt.isNull(_columnIndexOfSubChannelName) ? null : _stmt.getText(_columnIndexOfSubChannelName);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfSubChannelUpdatedAt) ? null : _stmt.getText(_columnIndexOfSubChannelUpdatedAt);
                    DateTime _tmpSubChannelUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_2 != 0;
                    int _tmpSegment = (int)_stmt.getLong(_columnIndexOfSegment);
                    _result = new MessagePreviewEntity(_tmpMessagePreviewId, _tmpDataType, _tmpData, _tmpChannelId, _tmpSubChannelId, _tmpSubChannelName, _tmpSubChannelUpdatedAt, _tmpCreatorId, _tmpIsDeleted, _tmpSegment);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                MessagePreviewEntity messagePreviewEntity = _result;
                return messagePreviewEntity;
            }
        });
    }

    @Override
    public MessagePreviewEntity getByIdMessageIdNow(String messagePreviewId) {
        String _sql = "SELECT * from message_preview where messagePreviewId = ? LIMIT 1";
        return (MessagePreviewEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from message_preview where messagePreviewId = ? LIMIT 1");){
                MessagePreviewEntity _result;
                int _argIndex = 1;
                if (messagePreviewId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messagePreviewId);
                }
                int _columnIndexOfMessagePreviewId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfSubChannelName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelName");
                int _columnIndexOfSubChannelUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelUpdatedAt");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segment");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpMessagePreviewId = _stmt.isNull(_columnIndexOfMessagePreviewId) ? null : _stmt.getText(_columnIndexOfMessagePreviewId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    String _tmpSubChannelName = _stmt.isNull(_columnIndexOfSubChannelName) ? null : _stmt.getText(_columnIndexOfSubChannelName);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfSubChannelUpdatedAt) ? null : _stmt.getText(_columnIndexOfSubChannelUpdatedAt);
                    DateTime _tmpSubChannelUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_2 != 0;
                    int _tmpSegment = (int)_stmt.getLong(_columnIndexOfSegment);
                    _result = new MessagePreviewEntity(_tmpMessagePreviewId, _tmpDataType, _tmpData, _tmpChannelId, _tmpSubChannelId, _tmpSubChannelName, _tmpSubChannelUpdatedAt, _tmpCreatorId, _tmpIsDeleted, _tmpSegment);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                MessagePreviewEntity messagePreviewEntity = _result;
                return messagePreviewEntity;
            }
        });
    }

    @Override
    public MessagePreviewEntity getByChannelId(String channelId) {
        String _sql = "SELECT * from message_preview where channelId = ? order by updatedAt desc LIMIT 1";
        return (MessagePreviewEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from message_preview where channelId = ? order by updatedAt desc LIMIT 1");){
                MessagePreviewEntity _result;
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                int _columnIndexOfMessagePreviewId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewId");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfSubChannelName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelName");
                int _columnIndexOfSubChannelUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelUpdatedAt");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"segment");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpMessagePreviewId = _stmt.isNull(_columnIndexOfMessagePreviewId) ? null : _stmt.getText(_columnIndexOfMessagePreviewId);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    String _tmp = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    String _tmpSubChannelName = _stmt.isNull(_columnIndexOfSubChannelName) ? null : _stmt.getText(_columnIndexOfSubChannelName);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfSubChannelUpdatedAt) ? null : _stmt.getText(_columnIndexOfSubChannelUpdatedAt);
                    DateTime _tmpSubChannelUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_2 != 0;
                    int _tmpSegment = (int)_stmt.getLong(_columnIndexOfSegment);
                    _result = new MessagePreviewEntity(_tmpMessagePreviewId, _tmpDataType, _tmpData, _tmpChannelId, _tmpSubChannelId, _tmpSubChannelName, _tmpSubChannelUpdatedAt, _tmpCreatorId, _tmpIsDeleted, _tmpSegment);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                MessagePreviewEntity messagePreviewEntity = _result;
                return messagePreviewEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from message_preview";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from message_preview");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void deleteById(String messagePreviewId) {
        String _sql = "DELETE from message_preview where messagePreviewId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from message_preview where messagePreviewId = ?");){
                int _argIndex = 1;
                if (messagePreviewId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messagePreviewId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void updateSubChannelInfo(String subChannelId, String subChannelName, DateTime subChannelUpdatedAt) {
        String _sql = "UPDATE message_preview set subChannelName = ?, subChannelUpdatedAt = ? where subChannelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE message_preview set subChannelName = ?, subChannelUpdatedAt = ? where subChannelId = ?");){
                int _argIndex = 1;
                if (subChannelName == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelName);
                }
                _argIndex = 2;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(subChannelUpdatedAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                _argIndex = 3;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _stmt.step();
                Object var8_8 = null;
                return var8_8;
            }
        });
    }

    @Override
    public void clearDeletedMessagePreviews() {
        String _sql = "DELETE from message_preview where isDeleted != 0";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from message_preview where isDeleted != 0");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

