/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoLocalFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoMessageFlag;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoMessageFlagDao_Impl
extends EkoMessageFlagDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EkoMessageFlag> __insertAdapterOfEkoMessageFlag;
    private final EkoFlagTypeConverter __ekoFlagTypeConverter = new EkoFlagTypeConverter();
    private final EkoLocalFlagTypeConverter __ekoLocalFlagTypeConverter = new EkoLocalFlagTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<EkoMessageFlag> __deleteAdapterOfEkoMessageFlag;
    private final EntityDeleteOrUpdateAdapter<EkoMessageFlag> __updateAdapterOfEkoMessageFlag;

    public EkoMessageFlagDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEkoMessageFlag = new EntityInsertAdapter<EkoMessageFlag>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `message_flag` (`messageId`,`flag`,`localFlag`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoMessageFlag entity) {
                if (entity.getMessageId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getMessageId());
                }
                String _tmp = EkoMessageFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(entity.getFlag());
                if (_tmp == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, _tmp);
                }
                String _tmp_1 = EkoMessageFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(entity.getLocalFlag());
                if (_tmp_1 == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp_1);
                }
                String _tmp_2 = EkoMessageFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_2);
                }
                String _tmp_3 = EkoMessageFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_3);
                }
                String _tmp_4 = EkoMessageFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_4);
                }
            }
        };
        this.__deleteAdapterOfEkoMessageFlag = new EntityDeleteOrUpdateAdapter<EkoMessageFlag>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `message_flag` WHERE `messageId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoMessageFlag entity) {
                if (entity.getMessageId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getMessageId());
                }
            }
        };
        this.__updateAdapterOfEkoMessageFlag = new EntityDeleteOrUpdateAdapter<EkoMessageFlag>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `message_flag` SET `messageId` = ?,`flag` = ?,`localFlag` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `messageId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoMessageFlag entity) {
                if (entity.getMessageId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getMessageId());
                }
                String _tmp = EkoMessageFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(entity.getFlag());
                if (_tmp == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, _tmp);
                }
                String _tmp_1 = EkoMessageFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(entity.getLocalFlag());
                if (_tmp_1 == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp_1);
                }
                String _tmp_2 = EkoMessageFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_2);
                }
                String _tmp_3 = EkoMessageFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_3);
                }
                String _tmp_4 = EkoMessageFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_4);
                }
                if (entity.getMessageId() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getMessageId());
                }
            }
        };
    }

    @Override
    public void insertImpl(EkoMessageFlag object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoMessageFlag.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends EkoMessageFlag> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoMessageFlag.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(EkoMessageFlag object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoMessageFlag.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends EkoMessageFlag> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoMessageFlag.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(EkoMessageFlag object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfEkoMessageFlag.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(EkoMessageFlag object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoMessageFlagDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends EkoMessageFlag> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoMessageFlagDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(EkoMessageFlag object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoMessageFlagDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    EkoMessageFlag getByIdNowImpl(String messageId) {
        String _sql = "SELECT * from message_flag where messageId = ? LIMIT 1";
        return (EkoMessageFlag)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from message_flag where messageId = ? LIMIT 1");){
                EkoMessageFlag _result;
                int _argIndex = 1;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messageId);
                }
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfFlag = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flag");
                int _columnIndexOfLocalFlag = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localFlag");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    String _tmp = _stmt.isNull(_columnIndexOfFlag) ? null : _stmt.getText(_columnIndexOfFlag);
                    EkoFlag _tmpFlag = this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfLocalFlag) ? null : _stmt.getText(_columnIndexOfLocalFlag);
                    EkoLocalFlag _tmpLocalFlag = this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                    _result = new EkoMessageFlag(_tmpMessageId, _tmpFlag, _tmpLocalFlag);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoMessageFlag ekoMessageFlag = _result;
                return ekoMessageFlag;
            }
        });
    }

    @Override
    EkoMessageFlag getByMessageIdImpl(String messageId) {
        String _sql = "SELECT * from message_flag where message_flag.messageId = ? LIMIT 1";
        return (EkoMessageFlag)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from message_flag where message_flag.messageId = ? LIMIT 1");){
                EkoMessageFlag _result;
                int _argIndex = 1;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messageId);
                }
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfFlag = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flag");
                int _columnIndexOfLocalFlag = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localFlag");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    String _tmp = _stmt.isNull(_columnIndexOfFlag) ? null : _stmt.getText(_columnIndexOfFlag);
                    EkoFlag _tmpFlag = this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfLocalFlag) ? null : _stmt.getText(_columnIndexOfLocalFlag);
                    EkoLocalFlag _tmpLocalFlag = this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                    _result = new EkoMessageFlag(_tmpMessageId, _tmpFlag, _tmpLocalFlag);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoMessageFlag ekoMessageFlag = _result;
                return ekoMessageFlag;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from message_flag";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from message_flag");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

