/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoFollowCountDao;
import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoFollowCountDao_Impl
extends EkoFollowCountDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EkoFollowCountEntity> __insertAdapterOfEkoFollowCountEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<EkoFollowCountEntity> __deleteAdapterOfEkoFollowCountEntity;
    private final EntityDeleteOrUpdateAdapter<EkoFollowCountEntity> __updateAdapterOfEkoFollowCountEntity;

    public EkoFollowCountDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEkoFollowCountEntity = new EntityInsertAdapter<EkoFollowCountEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `user_follow_count` (`userId`,`followerCount`,`followingCount`,`pendingCount`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoFollowCountEntity entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
                if (entity.getFollowerCount() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindLong(2, (long)entity.getFollowerCount().intValue());
                }
                if (entity.getFollowingCount() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindLong(3, (long)entity.getFollowingCount().intValue());
                }
                if (entity.getPendingCount() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindLong(4, (long)entity.getPendingCount().intValue());
                }
                String _tmp = EkoFollowCountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = EkoFollowCountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                String _tmp_2 = EkoFollowCountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
            }
        };
        this.__deleteAdapterOfEkoFollowCountEntity = new EntityDeleteOrUpdateAdapter<EkoFollowCountEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `user_follow_count` WHERE `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoFollowCountEntity entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
            }
        };
        this.__updateAdapterOfEkoFollowCountEntity = new EntityDeleteOrUpdateAdapter<EkoFollowCountEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `user_follow_count` SET `userId` = ?,`followerCount` = ?,`followingCount` = ?,`pendingCount` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoFollowCountEntity entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
                if (entity.getFollowerCount() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindLong(2, (long)entity.getFollowerCount().intValue());
                }
                if (entity.getFollowingCount() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindLong(3, (long)entity.getFollowingCount().intValue());
                }
                if (entity.getPendingCount() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindLong(4, (long)entity.getPendingCount().intValue());
                }
                String _tmp = EkoFollowCountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = EkoFollowCountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                String _tmp_2 = EkoFollowCountDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getUserId());
                }
            }
        };
    }

    @Override
    public void insertImpl(EkoFollowCountEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoFollowCountEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends EkoFollowCountEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoFollowCountEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(EkoFollowCountEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoFollowCountEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends EkoFollowCountEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoFollowCountEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(EkoFollowCountEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfEkoFollowCountEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(EkoFollowCountEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoFollowCountDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends EkoFollowCountEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoFollowCountDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(EkoFollowCountEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoFollowCountDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    EkoFollowCountEntity getByIdNowImpl(String userId) {
        String _sql = "SELECT * from user_follow_count where userId = ? LIMIT 1";
        return (EkoFollowCountEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from user_follow_count where userId = ? LIMIT 1");){
                EkoFollowCountEntity _result;
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfFollowerCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"followerCount");
                int _columnIndexOfFollowingCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"followingCount");
                int _columnIndexOfPendingCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pendingCount");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    Integer _tmpFollowerCount = _stmt.isNull(_columnIndexOfFollowerCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfFollowerCount));
                    Integer _tmpFollowingCount = _stmt.isNull(_columnIndexOfFollowingCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfFollowingCount));
                    Integer _tmpPendingCount = _stmt.isNull(_columnIndexOfPendingCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfPendingCount));
                    _result = new EkoFollowCountEntity(_tmpUserId, _tmpFollowerCount, _tmpFollowingCount, _tmpPendingCount);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoFollowCountEntity ekoFollowCountEntity = _result;
                return ekoFollowCountEntity;
            }
        });
    }

    @Override
    Flowable<EkoFollowCountEntity> getByIdImpl(String userId) {
        String _sql = "SELECT * from user_follow_count where user_follow_count.userId = ? LIMIT 1";
        return androidx.room.rxjava3.RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_follow_count"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from user_follow_count where user_follow_count.userId = ? LIMIT 1");){
                EkoFollowCountEntity _result;
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfFollowerCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"followerCount");
                int _columnIndexOfFollowingCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"followingCount");
                int _columnIndexOfPendingCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pendingCount");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    Integer _tmpFollowerCount = _stmt.isNull(_columnIndexOfFollowerCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfFollowerCount));
                    Integer _tmpFollowingCount = _stmt.isNull(_columnIndexOfFollowingCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfFollowingCount));
                    Integer _tmpPendingCount = _stmt.isNull(_columnIndexOfPendingCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfPendingCount));
                    _result = new EkoFollowCountEntity(_tmpUserId, _tmpFollowerCount, _tmpFollowingCount, _tmpPendingCount);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoFollowCountEntity ekoFollowCountEntity = _result;
                return ekoFollowCountEntity;
            }
        });
    }

    @Override
    io.reactivex.Flowable<List<EkoFollowCountEntity>> getAllByIdImpl(String userId) {
        String _sql = "SELECT * from user_follow_count where user_follow_count.userId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_follow_count"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from user_follow_count where user_follow_count.userId = ?");){
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfFollowerCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"followerCount");
                int _columnIndexOfFollowingCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"followingCount");
                int _columnIndexOfPendingCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pendingCount");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoFollowCountEntity> _result = new ArrayList<EkoFollowCountEntity>();
                while (_stmt.step()) {
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    Integer _tmpFollowerCount = _stmt.isNull(_columnIndexOfFollowerCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfFollowerCount));
                    Integer _tmpFollowingCount = _stmt.isNull(_columnIndexOfFollowingCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfFollowingCount));
                    Integer _tmpPendingCount = _stmt.isNull(_columnIndexOfPendingCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfPendingCount));
                    EkoFollowCountEntity _item = new EkoFollowCountEntity(_tmpUserId, _tmpFollowerCount, _tmpFollowingCount, _tmpPendingCount);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<EkoFollowCountEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from user_follow_count";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from user_follow_count");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void updateFollowerCount(String userId, int followerCount) {
        String _sql = "UPDATE user_follow_count set followerCount = ? where userId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE user_follow_count set followerCount = ? where userId = ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)followerCount);
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void updateFollowingCount(String userId, int followingCount) {
        String _sql = "UPDATE user_follow_count set followingCount = ? where userId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE user_follow_count set followingCount = ? where userId = ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)followingCount);
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void updatePendingCount(String userId, int pendingCount) {
        String _sql = "UPDATE user_follow_count set pendingCount = ? where userId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE user_follow_count set pendingCount = ? where userId = ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)pendingCount);
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

