package com.amity.socialcloud.sdk.core.data.notificationtray.notificationtrayseen

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Query
import com.amity.socialcloud.sdk.entity.core.notificationtray.NotificationTraySeenEntity
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao
import io.reactivex.rxjava3.core.Flowable
import org.joda.time.DateTime

@Dao
abstract class AmityNotificationTraySeenDao : EkoObjectDao<NotificationTraySeenEntity>() {

    @Query("SELECT *" +
            " from notificationTraySeen" +
            " where userId = :userId")
    abstract fun getByIdNowImpl(userId: String): NotificationTraySeenEntity?
    override fun getByIdNow(userId: String): NotificationTraySeenEntity? {
        return getByIdNowImpl(userId)
    }

    @Delete
    abstract override fun delete(notitray: NotificationTraySeenEntity)

    @Query("DELETE from notificationTraySeen")
    abstract override fun deleteAll()

    @Query(
        "SELECT *" +
                " from notificationTraySeen" +
                " where userId = :userId"
    )
    abstract fun observeNotificationTraySeenImpl(userId: String): Flowable<NotificationTraySeenEntity>
    fun observeNotificationTraySeen(userId: String): Flowable<NotificationTraySeenEntity> {
        return observeNotificationTraySeenImpl(userId)
    }

    @Query("UPDATE notificationTraySeen SET lastTraySeenAt = :lastTraySeenAt WHERE userId = :userId")
    abstract fun updateLastTraySeenAt(userId: String, lastTraySeenAt: DateTime): Int
    fun markAsSeen(userId: String, lastTraySeenAt: DateTime): Int {
        return updateLastTraySeenAt(userId, lastTraySeenAt)
    }


}