/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.UserPresenceDao;
import com.ekoapp.ekosdk.internal.entity.UserPresenceEntity;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class UserPresenceDao_Impl
extends UserPresenceDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<UserPresenceEntity> __insertAdapterOfUserPresenceEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<UserPresenceEntity> __deleteAdapterOfUserPresenceEntity;
    private final EntityDeleteOrUpdateAdapter<UserPresenceEntity> __updateAdapterOfUserPresenceEntity;

    public UserPresenceDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfUserPresenceEntity = new EntityInsertAdapter<UserPresenceEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `user_presence` (`userId`,`lastHeartbeat`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull UserPresenceEntity entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
                String _tmp = UserPresenceDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastHeartbeat());
                if (_tmp == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, _tmp);
                }
                String _tmp_1 = UserPresenceDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp_1);
                }
                String _tmp_2 = UserPresenceDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_2);
                }
                String _tmp_3 = UserPresenceDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_3);
                }
            }
        };
        this.__deleteAdapterOfUserPresenceEntity = new EntityDeleteOrUpdateAdapter<UserPresenceEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `user_presence` WHERE `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull UserPresenceEntity entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
            }
        };
        this.__updateAdapterOfUserPresenceEntity = new EntityDeleteOrUpdateAdapter<UserPresenceEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `user_presence` SET `userId` = ?,`lastHeartbeat` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull UserPresenceEntity entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
                String _tmp = UserPresenceDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastHeartbeat());
                if (_tmp == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, _tmp);
                }
                String _tmp_1 = UserPresenceDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp_1);
                }
                String _tmp_2 = UserPresenceDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_2);
                }
                String _tmp_3 = UserPresenceDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_3);
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getUserId());
                }
            }
        };
    }

    @Override
    public void insertImpl(UserPresenceEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfUserPresenceEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends UserPresenceEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfUserPresenceEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(UserPresenceEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfUserPresenceEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends UserPresenceEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfUserPresenceEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(UserPresenceEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfUserPresenceEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(UserPresenceEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            UserPresenceDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends UserPresenceEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            UserPresenceDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(UserPresenceEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            UserPresenceDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public UserPresenceEntity getByUserIdNow(String userId) {
        String _sql = "SELECT * from user_presence where user_presence.userId = ? LIMIT 1";
        return (UserPresenceEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from user_presence where user_presence.userId = ? LIMIT 1");){
                UserPresenceEntity _result;
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfLastHeartbeat = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastHeartbeat");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmp = _stmt.isNull(_columnIndexOfLastHeartbeat) ? null : _stmt.getText(_columnIndexOfLastHeartbeat);
                    DateTime _tmpLastHeartbeat = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result = new UserPresenceEntity(_tmpUserId, _tmpLastHeartbeat);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                UserPresenceEntity userPresenceEntity = _result;
                return userPresenceEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from user_presence";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from user_presence");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

