/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.file;

import android.net.Uri;
import co.amity.rxupload.RxUploadService;
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper;
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore;
import com.amity.socialcloud.sdk.core.data.file.FileRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.file.FileRepository;
import com.amity.socialcloud.sdk.core.data.file.RawFileModelMapper;
import com.amity.socialcloud.sdk.infra.upload.AmityAudioUploadService;
import com.amity.socialcloud.sdk.infra.upload.AmityClipUploadService;
import com.amity.socialcloud.sdk.infra.upload.AmityFileUploadService;
import com.amity.socialcloud.sdk.infra.upload.AmityImageUploadService;
import com.amity.socialcloud.sdk.infra.upload.AmityVideoUploadService;
import com.amity.socialcloud.sdk.model.core.content.AmityContentFeedType;
import com.amity.socialcloud.sdk.model.core.file.AmityAudio;
import com.amity.socialcloud.sdk.model.core.file.AmityClip;
import com.amity.socialcloud.sdk.model.core.file.AmityFile;
import com.amity.socialcloud.sdk.model.core.file.AmityImage;
import com.amity.socialcloud.sdk.model.core.file.AmityRawFile;
import com.amity.socialcloud.sdk.model.core.file.AmityVideo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadInfo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadResult;
import com.ekoapp.ekosdk.internal.EkoFileEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoFileDto;
import com.ekoapp.ekosdk.internal.api.socket.request.FileUpdateRequest;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0007\u001a\u00020\bJ.\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\bJ\"\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fJ\"\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fJ*\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%J*\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%J\u000e\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\bJ\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001b2\u0006\u0010\u001d\u001a\u00020\bJ\u000e\u0010+\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010,\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010-\u001a\u00020.\u00a8\u0006/"}, d2={"Lcom/amity/socialcloud/sdk/core/data/file/FileRepository;", "", "<init>", "()V", "getRawFile", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/model/core/file/AmityRawFile;", "fileId", "", "getLocalRawFile", "getLocalRawFileNow", "createLocalFile", "Lio/reactivex/rxjava3/core/Completable;", "fileType", "filePath", "getImage", "Lcom/amity/socialcloud/sdk/model/core/file/AmityImage;", "getImageNow", "getFile", "Lcom/amity/socialcloud/sdk/model/core/file/AmityFile;", "getAudio", "Lcom/amity/socialcloud/sdk/model/core/file/AmityAudio;", "getVideo", "Lcom/amity/socialcloud/sdk/model/core/file/AmityVideo;", "getClip", "Lcom/amity/socialcloud/sdk/model/core/file/AmityClip;", "uploadImage", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadResult;", "uploadId", "uri", "Landroid/net/Uri;", "altText", "uploadFile", "uploadAudio", "uploadVideo", "feedType", "Lcom/amity/socialcloud/sdk/model/core/content/AmityContentFeedType;", "uploadClip", "cancelUpload", "", "getUploadInfo", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadInfo;", "deleteFile", "updateFile", "request", "Lcom/ekoapp/ekosdk/internal/api/socket/request/FileUpdateRequest;", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nFileRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileRepository.kt\ncom/amity/socialcloud/sdk/core/data/file/FileRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
public final class FileRepository {
    @NotNull
    public final Single<AmityRawFile> getRawFile(@NotNull String fileId) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Single single = new FileLocalDataStore().getRawFile(fileId).flatMap(new Function(fileId){
            final /* synthetic */ String $fileId;
            {
                this.$fileId = $fileId;
            }

            public final SingleSource<? extends EkoFileEntity> apply(List<EkoFileEntity> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                boolean hasInCache = !((Collection)it).isEmpty();
                return (SingleSource)(hasInCache ? Single.just((Object)CollectionsKt.first(it)) : new FileRemoteDataStore().getFile(this.$fileId).flatMap(new Function(this.$fileId){
                    final /* synthetic */ String $fileId;
                    {
                        this.$fileId = $fileId;
                    }

                    public final SingleSource<? extends EkoFileEntity> apply(EkoFileDto dto) {
                        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                        return (SingleSource)new FileLocalDataStore().saveFiles(new FileEntityMapper().map(CollectionsKt.listOf((Object)dto))).andThen((SingleSource)Single.defer(() -> getRawFile.1.apply$lambda$0(this.$fileId)).map((Function)getRawFile.2.INSTANCE));
                    }

                    private static final SingleSource apply$lambda$0(String $fileId) {
                        return (SingleSource)new FileLocalDataStore().getRawFile($fileId);
                    }
                }));
            }
        }).map((Function)getRawFile.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"map(...)");
        return single;
    }

    private final AmityRawFile getLocalRawFile(String fileId) {
        Ref.ObjectRef rawFile = new Ref.ObjectRef();
        Completable.fromCallable(() -> FileRepository.getLocalRawFile$lambda$0(fileId, rawFile)).subscribeOn(Schedulers.io()).blockingAwait();
        return (AmityRawFile)rawFile.element;
    }

    private final AmityRawFile getLocalRawFileNow(String fileId) {
        AmityRawFile rawFile = null;
        EkoFileEntity entity = new FileLocalDataStore().getFile(fileId);
        if (entity != null) {
            rawFile = new RawFileModelMapper().map(entity);
        }
        return rawFile;
    }

    @NotNull
    public final Completable createLocalFile(@NotNull String fileId, @NotNull String fileType, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return new FileLocalDataStore().createLocalFile(fileId, fileType, filePath);
    }

    @Nullable
    public final AmityImage getImage(@NotNull String fileId) {
        AmityImage amityImage;
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        AmityRawFile amityRawFile = this.getLocalRawFile(fileId);
        if (amityRawFile != null) {
            AmityRawFile it = amityRawFile;
            boolean bl = false;
            amityImage = new AmityImage(it);
        } else {
            amityImage = null;
        }
        return amityImage;
    }

    @Nullable
    public final AmityImage getImageNow(@NotNull String fileId) {
        AmityImage amityImage;
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        AmityRawFile amityRawFile = this.getLocalRawFileNow(fileId);
        if (amityRawFile != null) {
            AmityRawFile it = amityRawFile;
            boolean bl = false;
            amityImage = new AmityImage(it);
        } else {
            amityImage = null;
        }
        return amityImage;
    }

    @Nullable
    public final AmityFile getFile(@NotNull String fileId) {
        AmityFile amityFile;
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        AmityRawFile amityRawFile = this.getLocalRawFile(fileId);
        if (amityRawFile != null) {
            AmityRawFile it = amityRawFile;
            boolean bl = false;
            amityFile = new AmityFile(it);
        } else {
            amityFile = null;
        }
        return amityFile;
    }

    @Nullable
    public final AmityAudio getAudio(@NotNull String fileId) {
        AmityAudio amityAudio;
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        AmityRawFile amityRawFile = this.getLocalRawFile(fileId);
        if (amityRawFile != null) {
            AmityRawFile it = amityRawFile;
            boolean bl = false;
            amityAudio = new AmityAudio(it);
        } else {
            amityAudio = null;
        }
        return amityAudio;
    }

    @Nullable
    public final AmityVideo getVideo(@NotNull String fileId) {
        AmityVideo amityVideo;
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        AmityRawFile amityRawFile = this.getLocalRawFile(fileId);
        if (amityRawFile != null) {
            AmityRawFile it = amityRawFile;
            boolean bl = false;
            amityVideo = new AmityVideo(it);
        } else {
            amityVideo = null;
        }
        return amityVideo;
    }

    @Nullable
    public final AmityClip getClip(@NotNull String fileId) {
        AmityClip amityClip;
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        AmityRawFile amityRawFile = this.getLocalRawFile(fileId);
        if (amityRawFile != null) {
            AmityRawFile it = amityRawFile;
            boolean bl = false;
            amityClip = new AmityClip(it);
        } else {
            amityClip = null;
        }
        return amityClip;
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityImage>> uploadImage(@NotNull String uploadId, @NotNull Uri uri, @Nullable String altText) {
        AmityImageUploadService.Builder builder;
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        AmityImageUploadService.Builder $this$uploadImage_u24lambda_u247 = builder = new AmityImageUploadService.Builder().fileUri$amity_sdk_release(uri).isFullImage(true).uploadId(uploadId);
        boolean bl = false;
        CharSequence charSequence = altText;
        if (!(charSequence == null || charSequence.length() == 0)) {
            $this$uploadImage_u24lambda_u247.altText(altText);
        }
        return builder.build().transfer();
    }

    public static /* synthetic */ Flowable uploadImage$default(FileRepository fileRepository, String string, Uri uri, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return fileRepository.uploadImage(string, uri, string2);
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityFile>> uploadFile(@NotNull String uploadId, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return new AmityFileUploadService.Builder().fileUri$amity_sdk_release(uri).uploadId(uploadId).build().transfer();
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityAudio>> uploadAudio(@NotNull String uploadId, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return new AmityAudioUploadService.Builder().fileUri$amity_sdk_release(uri).uploadId(uploadId).build().transfer();
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityVideo>> uploadVideo(@NotNull String uploadId, @NotNull Uri uri, @NotNull AmityContentFeedType feedType) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
        return new AmityVideoUploadService.Builder().fileUri$amity_sdk_release(uri).feedType$amity_sdk_release(feedType).uploadId(uploadId).build().transfer();
    }

    @NotNull
    public final Flowable<AmityUploadResult<AmityClip>> uploadClip(@NotNull String uploadId, @NotNull Uri uri, @NotNull AmityContentFeedType feedType) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
        return new AmityClipUploadService.Builder().fileUri$amity_sdk_release(uri).feedType$amity_sdk_release(feedType).uploadId(uploadId).build().transfer();
    }

    public final void cancelUpload(@NotNull String uploadId) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        RxUploadService.Companion.cancel(uploadId);
    }

    @NotNull
    public final Flowable<AmityUploadInfo> getUploadInfo(@NotNull String uploadId) {
        Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
        Flowable flowable = RxUploadService.Companion.properties(uploadId).map((Function)getUploadInfo.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @NotNull
    public final Completable deleteFile(@NotNull String fileId) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Completable completable = new FileRemoteDataStore().deleteFile(fileId).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"ignoreElement(...)");
        return completable;
    }

    @NotNull
    public final Completable updateFile(@NotNull String fileId, @NotNull FileUpdateRequest request) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Completable completable = new FileRemoteDataStore().updateFile(fileId, request).flatMapCompletable((Function)updateFile.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    private static final Unit getLocalRawFile$lambda$0(String $fileId, Ref.ObjectRef $rawFile) {
        EkoFileEntity entity = new FileLocalDataStore().getFile($fileId);
        if (entity != null) {
            $rawFile.element = new RawFileModelMapper().map(entity);
        }
        return Unit.INSTANCE;
    }
}

