package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import com.amity.socialcloud.sdk.api.social.category.query.AmityCommunityCategorySortOption
import com.ekoapp.ekosdk.internal.constants.SORT_OPTION

internal const val COMMUNITY_CATEGORY_QUERY_TOKEN_TABLE_NAME = "community_category_query_token"

@Entity(
		tableName = COMMUNITY_CATEGORY_QUERY_TOKEN_TABLE_NAME,
		primaryKeys = ["sortBy", "isDeleted", "pageNumber"]
)
class EkoCommunityCategoryQueryToken : EkoQueryToken(){
	var sortBy: String = AmityCommunityCategorySortOption.LAST_CREATED.apiKey
	var isDeleted = false
}