package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Query;

import com.amity.socialcloud.sdk.entity.social.category.CommunityCategoryEntity;

import org.joda.time.DateTime;

import java.util.List;

import io.reactivex.rxjava3.core.Flowable;


@Dao
public abstract class EkoCommunityCategoryDao extends EkoObjectDao<CommunityCategoryEntity> {

    @Delete
    public abstract void delete(CommunityCategoryEntity category);

    @Query("DELETE from community_category")
    public abstract void deleteAll();

    @Query("SELECT *" +
            " from community_category" +
            " where community_category.categoryId = (:id)")
    abstract CommunityCategoryEntity getByIdNowImpl(String id);

    @Override
    public CommunityCategoryEntity getByIdNow(String id) {
        return getByIdNowImpl(id);
    }

    @Query("SELECT *" +
            " from community_category" +
            " where community_category.categoryId = (:id)")
    abstract Flowable<CommunityCategoryEntity> observeByIdImpl(String id);

    public Flowable<CommunityCategoryEntity> observeById(String id) {
        return observeByIdImpl(id);
    }

    @Query("SELECT *" +
            " from community_category" +
            " where community_category.categoryId IN (:ids)")
    abstract List<CommunityCategoryEntity> getByIdsNowImpl(List<String> ids);

    @Override
    public List<CommunityCategoryEntity> getByIdsNow(List<String> ids) {
        return getByIdsNowImpl(ids);
    }

    @Query("SELECT *" +
            " from community_category" +
            " where community_category.isDeleted = " +
            "(case when :isDeleted is null then isDeleted else :isDeleted end)" +
            " and community_category.updatedAt > :now" +
            " and community_category.categoryId not in " +
            "(" +
            "SELECT amity_paging_id.id" +
            " from amity_paging_id" +
            " where amity_paging_id.hash = (:hash)" +
            " and amity_paging_id.nonce = (:nonce) " +
            ")" +
            " order by community_category.updatedAt  desc" +
            " limit 1")
    abstract Flowable<CommunityCategoryEntity> getLatestCategoryImpl(
            Boolean isDeleted,
            int hash,
            int nonce,
            DateTime now);

    public Flowable<CommunityCategoryEntity> getLatestCategory(
            Boolean isDeleted,
            int hash,
            int nonce,
            DateTime now) {
        return getLatestCategoryImpl(isDeleted, hash, nonce, now);
    }

}