package com.ekoapp.ekosdk.internal

import androidx.room.Entity
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.annotations.SerializedName
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Entity(tableName = "user_marker", primaryKeys = ["userId"])
open class UserMarkerEntity : EkoObject() {
    
    var userId: String = ObjectId.get().toHexString()
    var unreadCount : Int = 0
    var lastSyncAt: DateTime = DateTime.now()
    var hasMentioned: Boolean = false

    override fun getId(): String {
        return userId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is UserMarkerEntity
                && Objects.equal(userId, other.userId)
                && Objects.equal(unreadCount, other.unreadCount)
                && Objects.equal(lastSyncAt, other.lastSyncAt)
                && Objects.equal(createdAt, other.createdAt)
                && Objects.equal(updatedAt, other.updatedAt)
                && Objects.equal(hasMentioned, other.hasMentioned)
                )
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            userId,
            unreadCount,
            lastSyncAt,
            createdAt,
            updatedAt,
            hasMentioned
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("userId", userId)
            add("unreadCount", unreadCount)
            add("lastSyncAt", lastSyncAt)
            add("createdAt", createdAt)
            add("updatedAt", updatedAt)
            add("hasMentioned", hasMentioned)
        }
        return super.internalToString(toStringHelper)
    }

}