package com.amity.socialcloud.sdk.dto.social.story

import com.amity.socialcloud.sdk.model.social.story.AmityStoryImageDisplayMode
import com.amity.socialcloud.sdk.model.social.story.AmityStoryItem
import com.google.gson.JsonObject


class CreateImageStoryRequest(
    referenceId: String,
    targetType: String,
    targetId: String,
    fileId: String,
    storyItems: List<AmityStoryItem>,
    metadata: JsonObject?,
    imageDisplayMode: AmityStoryImageDisplayMode
    ) : CreateStoryRequest(
    referenceId = referenceId,
    targetType = targetType,
    targetId = targetId,
    dataType = "image",
    data = JsonObject().apply {
        addProperty("fileId", fileId)
        addProperty("imageDisplayMode", imageDisplayMode.apiKey)
    },
    metadata = metadata,
    items = storyItems.map {
        it.getPayload()
    }
)