package com.amity.socialcloud.sdk.core.domain.user

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.file.ImageGetNowUseCase
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.ekoapp.ekosdk.internal.usecase.presence.GetUserPresenceNowUseCase

internal class UserComposerUseCase : ComposerUseCase() {

    fun execute(user: AmityUser): AmityUser {
        addFlag(user)
        addAvatar(user)
        addLastHeartbeat(user)
        return user
    }

    private fun addFlag(user: AmityUser) {
        user.isFlaggedByMe = IsUserFlaggedByMeNowUseCase().execute(user.getUserId())
    }

    private fun addAvatar(user: AmityUser) {
        user.avatarFileId?.let {
            user.avatar = ImageGetNowUseCase().execute(it)
        }
    }

    private fun addLastHeartbeat(user: AmityUser) {
        user.lastHeartbeat = GetUserPresenceNowUseCase().execute(user.getUserId())?.getLastHeartbeat()
    }
}