package com.amity.socialcloud.sdk.core.domain.session

import com.amity.socialcloud.sdk.core.data.session.SessionRepository
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus
import com.amity.socialcloud.sdk.core.session.model.AppEvent
import com.amity.socialcloud.sdk.core.session.model.SessionLifeCycle
import com.ekoapp.ekosdk.internal.data.EkoDatabase
import com.ekoapp.ekosdk.internal.data.model.EkoAccount
import io.reactivex.rxjava3.core.Single
import org.joda.time.DateTime

internal class RenewTokenUseCase {

    fun execute(
        appEventBus: AppEventBus,
        sessionLifeCycleEventBus: SessionLifeCycleEventBus,
        ekoAccount: EkoAccount,
        authToken: String?,
        authSignature: String?,
        authSignatureExpiresAt: DateTime?
    ): Single<EkoAccount> {
        appEventBus.publish(AppEvent.LoggingIn)
        return SessionRepository().renewToken(
            account = ekoAccount,
            authToken = authToken,
            authSignature = authSignature,
            authSignatureExpiresAt = authSignatureExpiresAt,
            isLegacyVersion =  false
        )
            .andThen(
                EkoDatabase.get()
                    .accountDao()
                    .currentAccountSingle
            )
            .doOnSuccess {
                appEventBus.publish(AppEvent.LoginSuccess)
                sessionLifeCycleEventBus.publish(SessionLifeCycle.Establish(it))
            }
            .doOnError {
                appEventBus.publish(AppEvent.LoginFail)
            }
    }
}