package com.amity.socialcloud.sdk.chat.domain.channel

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel

internal class GetChannelUseCase {

    fun execute(channelId: String): AmityChannel? {
        return ChannelRepository().getChannelNow(channelId)
            ?.let { channels ->
                channels.let(ChannelComposerUseCase()::execute)
            }
    }
}