package com.amity.socialcloud.sdk.api.chat.channel.query

import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannelFilter
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.common.collect.FluentIterable
import com.google.common.collect.Sets

class AmitySelectedTypesChannelQuery private constructor(isDeleted: Boolean?,
                                                         types: Set<AmityChannel.Type>,
                                                         filter: AmityChannelFilter,
                                                         includingTags: AmityTags,
                                                         excludingTags: AmityTags
) : AmityChannelQuery(isDeleted, types, filter, includingTags, excludingTags) {
    class Builder internal constructor() {
        private var isDeleted: Boolean? = null
        private var types: Set<AmityChannel.Type> = Sets.newHashSet()
        private var filter: AmityChannelFilter = AmityChannelFilter.ALL
        private var includingTags = AmityTags()
        private var excludingTags = AmityTags()

        internal fun types(types: List<AmityChannel.Type>): Builder {
            this.types = FluentIterable.from(types).toSet()
            return this
        }

        fun filter(filter: AmityChannelFilter): Builder {
            this.filter = filter
            return this
        }

        fun includingTags(includingTags: AmityTags): Builder {
            this.includingTags = includingTags
            return this
        }

        fun excludingTags(excludingTags: AmityTags): Builder {
            this.excludingTags = excludingTags
            return this
        }

        fun includeDeleted(includeDeleted: Boolean): Builder {
            return apply {
                this.isDeleted = if(includeDeleted) null else false
            }
        }

        fun build(): AmitySelectedTypesChannelQuery {
            return AmitySelectedTypesChannelQuery(isDeleted, types, filter, includingTags, excludingTags)
        }
    }

}