package com.ekoapp.ekosdk.internal.usecase.message

import com.amity.socialcloud.sdk.chat.data.message.MessageRepository
import com.amity.socialcloud.sdk.chat.domain.message.MessageComposerUseCase
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.amity.socialcloud.sdk.api.chat.message.query.AmityMessageQuerySortOption
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import io.reactivex.rxjava3.core.Flowable

internal class MessageManualQueryUseCase {

    fun execute(
        subChannelId: String,
        parentId: String?,
        isFilterByParentId: Boolean,
        isDeleted: Boolean?,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        type: AmityMessage.DataType?,
        ids: List<String>,
        sortOption: AmityMessageQuerySortOption,
        hasMore: Boolean
    ): Flowable<List<AmityMessage>> {
        return getDataSource(
            subChannelId = subChannelId,
            parentId = parentId,
            isFilterByParentId = isFilterByParentId,
            isDeleted = isDeleted,
            includingTags = includingTags,
            excludingTags = excludingTags,
            type = type,
            sortOption = sortOption,
            ids = ids,
            hasMore = hasMore
        )
            .map {
                it.map {
                    MessageComposerUseCase().execute(it)
                }
            }
            .map {
                if (isDeleted == null) {
                    it
                } else {
                    it.filter { message -> message.isDeleted() == isDeleted }
                }
            }
    }

    private fun getDataSource(
        subChannelId: String,
        parentId: String?,
        isFilterByParentId: Boolean,
        isDeleted: Boolean?,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        type: AmityMessage.DataType?,
        sortOption: AmityMessageQuerySortOption,
        ids: List<String>,
        hasMore: Boolean
    ): Flowable<List<AmityMessage>> {
        return if (ids.isEmpty() && hasMore) {
            Flowable.never()
        } else {
            observeLocalMessages(
                subChannelId = subChannelId,
                parentId = parentId,
                isFilterByParentId = isFilterByParentId,
                isDeleted = isDeleted,
                includingTags = includingTags,
                excludingTags = excludingTags,
                type = type,
                sortOption = sortOption
            )
        }
    }

    private fun observeLocalMessages(
        subChannelId: String,
        parentId: String?,
        isFilterByParentId: Boolean,
        isDeleted: Boolean?,
        includingTags: AmityTags,
        excludingTags: AmityTags,
        type: AmityMessage.DataType?,
        sortOption: AmityMessageQuerySortOption
    ): Flowable<List<AmityMessage>> {
        return MessageRepository().observeMessages(
            subChannelId = subChannelId,
            isFilterByParentId = isFilterByParentId,
            parentId = parentId,
            includingTags = includingTags,
            excludingTags = excludingTags,
            isDeleted = isDeleted,
            type = type?.apiKey,
            sortOption = sortOption
        )
    }

}