package com.amity.socialcloud.sdk.api.social.event.query

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.model.social.event.AmityEvent
import com.amity.socialcloud.sdk.model.social.event.AmityEventRSVPStatus
import com.ekoapp.ekosdk.internal.usecase.event.GetMyEventsPagingDataUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityMyEventsQuery internal constructor(
    private val status: AmityEventRSVPStatus?
) {

    /**
     * Queries for events the current user has RSVP'd to.
     * @return Flowable<PagingData<AmityEvent>>.
     */
    fun query(): Flowable<PagingData<AmityEvent>> {
        return GetMyEventsPagingDataUseCase().execute(
            status = status
        )
    }

    class Builder {
        private var status: AmityEventRSVPStatus? = null

        /**
         * Specifies RSVP status to filter my events by response status.
         * @return the same AmityMyEventsQuery.Builder instance.
         */
        fun status(status: AmityEventRSVPStatus): Builder {
            return apply { this.status = status }
        }

        /**
         * Instantiates AmityMyEventsQuery with built params.
         * @return new instance of AmityMyEventsQuery.
         */
        fun build(): AmityMyEventsQuery {
            return AmityMyEventsQuery(
                status = status
            )
        }
    }
}
