/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Insert;
import com.ekoapp.ekosdk.PermissionEkoObject;
import com.ekoapp.ekosdk.internal.data.model.EkoPermissionObject;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;

public abstract class EkoPermissionDao<EntityType extends EkoPermissionObject> {
    static <PermissionObject extends PermissionEkoObject, PermissionFactoryObject extends EkoPermissionObject> void update(List<PermissionObject> ekoObjects, EkoPermissionDao<PermissionFactoryObject> dao, EkoPermissionObject.EkoPermissionFactory<PermissionFactoryObject> factory2) {
        for (PermissionEkoObject ekoObject : ekoObjects) {
            EkoPermissionDao.update(ekoObject, dao, factory2);
        }
    }

    static <PermissionFactoryObject extends EkoPermissionObject> void update(PermissionEkoObject ekoObject, EkoPermissionDao<PermissionFactoryObject> dao, EkoPermissionObject.EkoPermissionFactory<PermissionFactoryObject> factory2) {
        Object[] permissions = ekoObject.getPermissions().toArray(new String[0]);
        ImmutableList list = FluentIterable.from((Object[])permissions).transform(permission -> factory2.create(ekoObject.getReferencePermissionId(), ekoObject.getUserId(), (String)permission)).toList();
        dao.insert((List<PermissionFactoryObject>)list);
        dao.retainAll(ekoObject.getReferencePermissionId(), ekoObject.getUserId(), (String[])permissions);
    }

    @Insert(onConflict=1)
    abstract void insert(List<EntityType> var1);

    abstract void retainAll(String var1, String var2, String[] var3);
}

