/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.domain.story;

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase;
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase;
import com.amity.socialcloud.sdk.core.domain.file.VideoGetUseCase;
import com.amity.socialcloud.sdk.core.domain.reaction.MyReactionsGetUseCase;
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType;
import com.amity.socialcloud.sdk.model.social.story.AmityStory;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryImageDisplayMode;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryItem;
import com.amity.socialcloud.sdk.social.domain.storytarget.get.GetStoryTargetUseCase;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u000f\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/amity/socialcloud/sdk/social/domain/story/StoryComposerUseCase;", "Lcom/amity/socialcloud/sdk/core/domain/ComposerUseCase;", "<init>", "()V", "execute", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStory;", "story", "addTarget", "", "addData", "getImageFileId", "", "rawData", "Lcom/google/gson/JsonObject;", "getVideoFileId", "getThumbnailFileId", "addStoryItems", "mapStoryItems", "", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStoryItem;", "rawStoryItems", "Lcom/google/gson/JsonArray;", "addCreator", "addMyReactions", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nStoryComposerUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoryComposerUseCase.kt\ncom/amity/socialcloud/sdk/social/domain/story/StoryComposerUseCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1563#2:103\n1634#2,3:104\n*S KotlinDebug\n*F\n+ 1 StoryComposerUseCase.kt\ncom/amity/socialcloud/sdk/social/domain/story/StoryComposerUseCase\n*L\n72#1:103\n72#1:104,3\n*E\n"})
public final class StoryComposerUseCase
extends ComposerUseCase {
    @NotNull
    public final AmityStory execute(@NotNull AmityStory story) {
        Intrinsics.checkNotNullParameter((Object)story, (String)"story");
        this.addTarget(story);
        this.addData(story);
        this.addCreator(story);
        this.addStoryItems(story);
        this.addMyReactions(story);
        return story;
    }

    private final void addTarget(AmityStory story) {
        story.setTarget$amity_sdk_release(new GetStoryTargetUseCase().execute(story.getTargetType(), story.getTargetId()));
    }

    private final void addData(AmityStory story) {
        switch (WhenMappings.$EnumSwitchMapping$0[story.getDataType().ordinal()]) {
            case 1: {
                String string = story.getStoryId();
                JsonObject jsonObject = story.getRawData$amity_sdk_release();
                Object object = story.getRawData$amity_sdk_release();
                if (object == null || (object = object.get("imageDisplayMode")) == null || (object = object.getAsString()) == null) {
                    object = "";
                }
                story.setData$amity_sdk_release(new AmityStory.Data.IMAGE(string, jsonObject, AmityStoryImageDisplayMode.Companion.enumOf((String)object), new ImageGetUseCase().execute(this.getImageFileId(story.getRawData$amity_sdk_release()))));
                break;
            }
            case 2: {
                story.setData$amity_sdk_release(new AmityStory.Data.VIDEO(story.getStoryId(), story.getRawData$amity_sdk_release(), new ImageGetUseCase().execute(this.getThumbnailFileId(story.getRawData$amity_sdk_release())), new VideoGetUseCase().execute(this.getVideoFileId(story.getRawData$amity_sdk_release()))));
            }
        }
    }

    private final String getImageFileId(JsonObject rawData) {
        Object object = rawData;
        if (object == null || (object = object.get("fileId")) == null || (object = object.getAsString()) == null) {
            object = "";
        }
        return object;
    }

    private final String getVideoFileId(JsonObject rawData) {
        Object object = rawData;
        if (object == null || (object = object.getAsJsonObject("videoFileId")) == null || (object = object.get("original")) == null || (object = object.getAsString()) == null) {
            object = "";
        }
        return object;
    }

    private final String getThumbnailFileId(JsonObject rawData) {
        Object object = rawData;
        if (object == null || (object = object.get("thumbnailFileId")) == null || (object = object.getAsString()) == null) {
            object = "";
        }
        return object;
    }

    private final void addStoryItems(AmityStory story) {
        story.setStoryItems$amity_sdk_release(this.mapStoryItems(story.getRawStoryItems$amity_sdk_release()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<AmityStoryItem> mapStoryItems(JsonArray rawStoryItems) {
        List list;
        JsonArray jsonArray = rawStoryItems;
        if (jsonArray != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)jsonArray;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonElement jsonElement = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                JsonObject item = it.getAsJsonObject();
                JsonElement jsonElement2 = item.get("type");
                String itemType = jsonElement2 != null ? jsonElement2.getAsString() : null;
                JsonElement jsonElement3 = item.get("data");
                Object data = jsonElement3 != null ? jsonElement3.getAsJsonObject() : null;
                Object object = data;
                if (object == null || (object = object.get("url")) == null || (object = object.getAsString()) == null) {
                    object = "";
                }
                Object url = object;
                JsonObject jsonObject = data;
                String customText = jsonObject != null && (jsonObject = jsonObject.get("customText")) != null ? jsonObject.getAsString() : null;
                AmityStoryItem storyItem = Intrinsics.areEqual((Object)itemType, (Object)"hyperlink") ? (AmityStoryItem)new AmityStoryItem.HYPERLINK((String)url, customText) : (AmityStoryItem)AmityStoryItem.UNKNOWN.INSTANCE;
                collection.add(storyItem);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void addCreator(AmityStory story) {
        story.setCreator$amity_sdk_release(new UserGetUseCase().execute(story.getCreatorId()));
    }

    private final void addMyReactions(AmityStory story) {
        story.setMyReactions$amity_sdk_release(new MyReactionsGetUseCase().execute(AmityReactionReferenceType.STORY, story.getStoryId()));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AmityStory.DataType.values().length];
            try {
                nArray[AmityStory.DataType.IMAGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AmityStory.DataType.VIDEO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

