/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.model.core.presence;

import com.amity.socialcloud.sdk.core.data.presence.PresenceRepository;
import com.amity.socialcloud.sdk.core.domain.user.UserGetByIdsUseCase;
import com.amity.socialcloud.sdk.model.core.presence.AmityUserPresence;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000f\u001a\u00020\u000bJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/amity/socialcloud/sdk/model/core/presence/AmityOnlineUsersSnapshot;", "", "<init>", "()V", "userPresences", "", "Lcom/amity/socialcloud/sdk/model/core/presence/AmityUserPresence;", "users", "", "Lcom/amity/socialcloud/sdk/model/core/user/AmityUser;", "fetchedAt", "Lorg/joda/time/DateTime;", "kotlin.jvm.PlatformType", "currentPage", "", "getFetchedAt", "getUsers", "loadMore", "Lio/reactivex/rxjava3/core/Completable;", "canLoadMore", "", "getOnlineUsers", "loadPage", "getPaginatedUserPresences", "getUsersByIds", "userIds", "", "", "Companion", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nAmityOnlineUsersSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmityOnlineUsersSnapshot.kt\ncom/amity/socialcloud/sdk/model/core/presence/AmityOnlineUsersSnapshot\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1563#2:88\n1634#2,3:89\n1#3:92\n*S KotlinDebug\n*F\n+ 1 AmityOnlineUsersSnapshot.kt\ncom/amity/socialcloud/sdk/model/core/presence/AmityOnlineUsersSnapshot\n*L\n52#1:88\n52#1:89,3\n*E\n"})
public final class AmityOnlineUsersSnapshot {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<AmityUserPresence> userPresences = new ArrayList();
    @NotNull
    private List<AmityUser> users = new ArrayList();
    private DateTime fetchedAt = DateTime.now();
    private int currentPage;
    private static final int PAGE_SIZE = 20;

    @NotNull
    public final DateTime getFetchedAt() {
        DateTime dateTime = this.fetchedAt;
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"fetchedAt");
        return dateTime;
    }

    @NotNull
    public final List<AmityUser> getUsers() {
        return this.users;
    }

    @NotNull
    public final Completable loadMore() {
        if (!this.canLoadMore()) {
            Completable completable = Completable.complete();
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"complete(...)");
            return completable;
        }
        ++this.currentPage;
        return this.loadPage();
    }

    public final boolean canLoadMore() {
        return this.users.size() < this.userPresences.size();
    }

    private final Completable getOnlineUsers() {
        Completable completable = new PresenceRepository().getOnlineUsers().subscribeOn(Schedulers.io()).flatMapCompletable(new Function(this){
            final /* synthetic */ AmityOnlineUsersSnapshot this$0;
            {
                this.this$0 = $receiver;
            }

            public final CompletableSource apply(List<AmityUserPresence> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                AmityOnlineUsersSnapshot.access$setUserPresences$p(this.this$0, it);
                AmityOnlineUsersSnapshot.access$setFetchedAt$p(this.this$0, DateTime.now());
                return (CompletableSource)AmityOnlineUsersSnapshot.access$loadPage(this.this$0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    private final Completable loadPage() {
        List<AmityUserPresence> paginatedUserPresences = this.getPaginatedUserPresences();
        Completable completable = Completable.fromAction(() -> AmityOnlineUsersSnapshot.loadPage$lambda$3(paginatedUserPresences, this));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    private final List<AmityUserPresence> getPaginatedUserPresences() {
        if (this.userPresences.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int upperBound = this.userPresences.size();
        int fromIndex = RangesKt.coerceAtMost((int)(this.currentPage * 20), (int)(upperBound - 1));
        int toIndex = RangesKt.coerceAtMost((int)(fromIndex + 20), (int)upperBound);
        return this.userPresences.subList(fromIndex, toIndex);
    }

    private final List<AmityUser> getUsersByIds(Set<String> userIds) {
        if (userIds.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Object object = new UserGetByIdsUseCase().execute(userIds).subscribeOn(Schedulers.io()).onErrorReturnItem((Object)CollectionsKt.emptyList()).blockingFirst((Object)CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"blockingFirst(...)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final void loadPage$lambda$3(List $paginatedUserPresences, AmityOnlineUsersSnapshot this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $paginatedUserPresences;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AmityUserPresence amityUserPresence = (AmityUserPresence)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUserId());
        }
        Collection<Object> it = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean bl = false;
        it = this$0.getUsersByIds((Set<String>)it);
        boolean bl2 = false;
        this$0.users.addAll(it);
    }

    public static final /* synthetic */ void access$setUserPresences$p(AmityOnlineUsersSnapshot $this, List list) {
        $this.userPresences = list;
    }

    public static final /* synthetic */ void access$setFetchedAt$p(AmityOnlineUsersSnapshot $this, DateTime dateTime) {
        $this.fetchedAt = dateTime;
    }

    public static final /* synthetic */ Completable access$loadPage(AmityOnlineUsersSnapshot $this) {
        return $this.loadPage();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u00a2\u0006\u0002\b\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/amity/socialcloud/sdk/model/core/presence/AmityOnlineUsersSnapshot$Companion;", "", "<init>", "()V", "PAGE_SIZE", "", "create", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/model/core/presence/AmityOnlineUsersSnapshot;", "create$amity_sdk_release", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Single<AmityOnlineUsersSnapshot> create$amity_sdk_release() {
            AmityOnlineUsersSnapshot snapshot = new AmityOnlineUsersSnapshot();
            Single single = snapshot.getOnlineUsers().toSingle(() -> Companion.create$lambda$0(snapshot));
            Intrinsics.checkNotNullExpressionValue((Object)single, (String)"toSingle(...)");
            return single;
        }

        private static final AmityOnlineUsersSnapshot create$lambda$0(AmityOnlineUsersSnapshot $snapshot) {
            return $snapshot;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

