/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.model.core.error;

import com.amity.socialcloud.sdk.model.core.error.AmityError;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import retrofit2.HttpException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0016\u0018\u0000 \u00112\u00060\u0001j\u0002`\u0002:\u0001\u0011B/\b\u0004\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\t\u001a\u0004\u0018\u00010\bX\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/amity/socialcloud/sdk/model/core/error/AmityException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "cause", "", "code", "", "httpStatusCode", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;ILjava/lang/Integer;)V", "getCode", "()I", "getHttpStatusCode$amity_sdk_release", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "Companion", "amity-sdk_release"})
public class AmityException
extends Exception {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int code;
    @Nullable
    private final Integer httpStatusCode;

    protected AmityException(@Nullable String message, @Nullable Throwable cause, int code, @Nullable Integer httpStatusCode) {
        super(message, cause);
        this.code = code;
        this.httpStatusCode = httpStatusCode;
    }

    public final int getCode() {
        return this.code;
    }

    @Nullable
    public final Integer getHttpStatusCode$amity_sdk_release() {
        return this.httpStatusCode;
    }

    @JvmStatic
    @NotNull
    public static final AmityException create(@Nullable String message, @Nullable Throwable cause, int code, @Nullable Integer httpStatusCode) {
        return Companion.create(message, cause, code, httpStatusCode);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ5\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\r2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lcom/amity/socialcloud/sdk/model/core/error/AmityException$Companion;", "", "<init>", "()V", "create", "Lcom/amity/socialcloud/sdk/model/core/error/AmityException;", "message", "", "cause", "", "error", "Lcom/amity/socialcloud/sdk/model/core/error/AmityError;", "httpStatusCode", "", "(Ljava/lang/String;Ljava/lang/Throwable;Lcom/amity/socialcloud/sdk/model/core/error/AmityError;Ljava/lang/Integer;)Lcom/amity/socialcloud/sdk/model/core/error/AmityException;", "code", "(Ljava/lang/String;Ljava/lang/Throwable;ILjava/lang/Integer;)Lcom/amity/socialcloud/sdk/model/core/error/AmityException;", "fromThrowable", "throwable", "fromResponse", "response", "Lokhttp3/Response;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AmityException create(@Nullable String message, @Nullable Throwable cause, @NotNull AmityError error, @Nullable Integer httpStatusCode) {
            Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
            return this.create(message, cause, error.getCode(), httpStatusCode);
        }

        public static /* synthetic */ AmityException create$default(Companion companion, String string, Throwable throwable, AmityError amityError, Integer n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = null;
            }
            return companion.create(string, throwable, amityError, n);
        }

        @JvmStatic
        @NotNull
        public final AmityException create(@Nullable String message, @Nullable Throwable cause, int code, @Nullable Integer httpStatusCode) {
            return new AmityException(message, cause, code, httpStatusCode);
        }

        public static /* synthetic */ AmityException create$default(Companion companion, String string, Throwable throwable, int n, Integer n2, int n3, Object object) {
            if ((n3 & 8) != 0) {
                n2 = null;
            }
            return companion.create(string, throwable, n, n2);
        }

        @NotNull
        public final AmityException fromThrowable(@NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            if (throwable instanceof HttpException) {
                String errorBody;
                retrofit2.Response response = ((HttpException)throwable).response();
                String string = response != null && (response = response.errorBody()) != null ? response.string() : (errorBody = null);
                if (errorBody != null) {
                    AmityException amityException;
                    try {
                        JSONObject error = new JSONObject(errorBody);
                        int code = error.getInt("code");
                        String message = error.getString("message");
                        amityException = this.create(message, null, AmityError.Companion.from(code), (Integer)((HttpException)throwable).code());
                    }
                    catch (Exception e) {
                        amityException = this.create("corrupted error format", null, AmityError.UNKNOWN, (Integer)((HttpException)throwable).code());
                    }
                    return amityException;
                }
            }
            if (throwable instanceof IOException) {
                return com.amity.socialcloud.sdk.model.core.error.AmityException$Companion.create$default(this, "network error", null, AmityError.CONNECTION_ERROR, null, 8, null);
            }
            if (throwable instanceof AmityException) {
                return (AmityException)throwable;
            }
            return com.amity.socialcloud.sdk.model.core.error.AmityException$Companion.create$default(this, "unknown error", null, AmityError.UNKNOWN, null, 8, null);
        }

        @NotNull
        public final AmityException fromResponse(@NotNull Response response) {
            AmityException amityException;
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            try {
                String errorBody = response.peekBody(Long.MAX_VALUE).string();
                JSONObject error = new JSONObject(errorBody);
                int code = error.getInt("code");
                String message = error.getString("message");
                amityException = com.amity.socialcloud.sdk.model.core.error.AmityException$Companion.create$default(this, message, null, AmityError.Companion.from(code), null, 8, null);
            }
            catch (Exception e) {
                amityException = com.amity.socialcloud.sdk.model.core.error.AmityException$Companion.create$default(this, "corrupted error format", null, AmityError.UNKNOWN, null, 8, null);
            }
            return amityException;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

