/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.reaction;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionLocalDataStore;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionModelMapper;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository;
import com.amity.socialcloud.sdk.core.data.reaction.paging.ReactionMediator;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.core.session.eventbus.LiveReactionEventBus;
import com.amity.socialcloud.sdk.model.core.reaction.AmityLiveReactionReferenceType;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReaction;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType;
import com.amity.socialcloud.sdk.model.core.reaction.live.AmityLiveReaction;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J,\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rJ\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\"\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00100\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u001bJ\u001c\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0010\u00a8\u0006\u001f"}, d2={"Lcom/amity/socialcloud/sdk/core/data/reaction/ReactionRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "<init>", "()V", "getDefaultPageSize", "", "getReactionPagingData", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagingData;", "Lcom/amity/socialcloud/sdk/model/core/reaction/AmityReaction;", "referenceType", "Lcom/amity/socialcloud/sdk/model/core/reaction/AmityReactionReferenceType;", "referenceId", "", "reactionName", "getMyReactions", "", "getLatestReaction", "addReaction", "Lio/reactivex/rxjava3/core/Completable;", "removeReaction", "getMyReaction", "Lio/reactivex/rxjava3/core/Maybe;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoReactionEntity;", "createMyReaction", "observeLiveReactions", "Lcom/amity/socialcloud/sdk/model/core/reaction/live/AmityLiveReaction;", "Lcom/amity/socialcloud/sdk/model/core/reaction/AmityLiveReactionReferenceType;", "addLiveReactions", "liveStreamId", "reactions", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nReactionRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactionRepository.kt\ncom/amity/socialcloud/sdk/core/data/reaction/ReactionRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1563#2:166\n1634#2,3:167\n*S KotlinDebug\n*F\n+ 1 ReactionRepository.kt\ncom/amity/socialcloud/sdk/core/data/reaction/ReactionRepository\n*L\n65#1:166\n65#1:167,3\n*E\n"})
public final class ReactionRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<PagingData<AmityReaction>> getReactionPagingData(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @Nullable String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        DynamicQueryStreamPagerCreator pagerCreator = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null), null, new ReactionMediator(referenceType, referenceId, reactionName), () -> ReactionRepository.getReactionPagingData$lambda$0(referenceType, referenceId, reactionName), (ModelMapper)new ReactionModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getMyReactions(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        List list = CollectionsKt.emptyList();
        EkoReactionDao reactionDao = UserDatabase.get().reactionDao();
        List<EkoReactionEntity> entities = reactionDao.getAllMyReactionsByReferenceTypeAndReferenceIdNow(referenceType.getValue(), referenceId);
        Intrinsics.checkNotNull(entities);
        if (!((Collection)entities).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = entities;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EkoReactionEntity ekoReactionEntity = (EkoReactionEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getReactionName());
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public final Flowable<AmityReaction> getLatestReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @Nullable String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Flowable flowable = new ReactionLocalDataStore().getLatestReaction(referenceType, referenceId, reactionName).map((Function)getLatestReaction.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @NotNull
    public final Completable addReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Completable completable = this.getMyReaction(referenceType, referenceId, reactionName).subscribeOn(Schedulers.io()).isEmpty().flatMapCompletable(new Function(this, referenceType, referenceId, reactionName){
            final /* synthetic */ ReactionRepository this$0;
            final /* synthetic */ AmityReactionReferenceType $referenceType;
            final /* synthetic */ String $referenceId;
            final /* synthetic */ String $reactionName;
            {
                this.this$0 = $receiver;
                this.$referenceType = $referenceType;
                this.$referenceId = $referenceId;
                this.$reactionName = $reactionName;
            }

            public final CompletableSource apply(boolean isEmpty) {
                CompletableSource completableSource;
                if (isEmpty) {
                    EkoReactionEntity reaction = this.this$0.createMyReaction(this.$referenceType, this.$referenceId, this.$reactionName);
                    completableSource = (CompletableSource)new ReactionLocalDataStore().addReaction(reaction).concatWith((CompletableSource)new ReactionRemoteDataStore().addReaction(this.$referenceType, this.$referenceId, this.$reactionName).ignoreElement().onErrorResumeNext(new Function(reaction){
                        final /* synthetic */ EkoReactionEntity $reaction;
                        {
                            this.$reaction = $reaction;
                        }

                        public final CompletableSource apply(Throwable throwable) {
                            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                            return (CompletableSource)new ReactionLocalDataStore().removeReaction(this.$reaction).andThen((CompletableSource)Completable.error((Throwable)throwable));
                        }
                    }));
                } else {
                    completableSource = (CompletableSource)Completable.complete();
                }
                return completableSource;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Completable removeReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Completable completable = this.getMyReaction(referenceType, referenceId, reactionName).subscribeOn(Schedulers.io()).flatMapCompletable(new Function(referenceType, referenceId, reactionName){
            final /* synthetic */ AmityReactionReferenceType $referenceType;
            final /* synthetic */ String $referenceId;
            final /* synthetic */ String $reactionName;
            {
                this.$referenceType = $referenceType;
                this.$referenceId = $referenceId;
                this.$reactionName = $reactionName;
            }

            public final CompletableSource apply(EkoReactionEntity removingReaction) {
                Intrinsics.checkNotNullParameter((Object)removingReaction, (String)"removingReaction");
                return (CompletableSource)new ReactionLocalDataStore().removeReaction(removingReaction).concatWith((CompletableSource)new ReactionRemoteDataStore().removeReaction(this.$referenceType, this.$referenceId, this.$reactionName).ignoreElement().onErrorResumeNext(new Function(removingReaction){
                    final /* synthetic */ EkoReactionEntity $removingReaction;
                    {
                        this.$removingReaction = $removingReaction;
                    }

                    public final CompletableSource apply(Throwable throwable) {
                        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                        return (CompletableSource)new ReactionLocalDataStore().addReaction(this.$removingReaction).andThen((CompletableSource)Completable.error((Throwable)throwable));
                    }
                }));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    private final Maybe<EkoReactionEntity> getMyReaction(AmityReactionReferenceType referenceType, String referenceId, String reactionName) {
        return new ReactionLocalDataStore().getReaction(referenceType, referenceId, reactionName, new SessionLocalDataStore().getActiveUserId());
    }

    @NotNull
    public final EkoReactionEntity createMyReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        return new ReactionLocalDataStore().createReaction(referenceType, referenceId, reactionName, new SessionLocalDataStore().getActiveUserId());
    }

    @NotNull
    public final Flowable<List<AmityLiveReaction>> observeLiveReactions(@NotNull String referenceId, @NotNull AmityLiveReactionReferenceType referenceType) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Flowable flowable = LiveReactionEventBus.INSTANCE.observe().map(new Function(referenceType, referenceId){
            final /* synthetic */ AmityLiveReactionReferenceType $referenceType;
            final /* synthetic */ String $referenceId;
            {
                this.$referenceType = $referenceType;
                this.$referenceId = $referenceId;
            }

            /*
             * WARNING - void declaration
             */
            public final List<AmityLiveReaction> apply(List<AmityLiveReaction> reactions) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter(reactions, (String)"reactions");
                Iterable iterable = reactions;
                AmityLiveReactionReferenceType amityLiveReactionReferenceType = this.$referenceType;
                String string = this.$referenceId;
                boolean $i$f$filter = false;
                void var6_6 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    AmityLiveReaction it = (AmityLiveReaction)element$iv$iv;
                    boolean bl = false;
                    String string2 = it.getReferenceType();
                    AmityLiveReactionReferenceType.Companion companion = AmityLiveReactionReferenceType.Companion;
                    String p0 = string2;
                    boolean bl2 = false;
                    if (!(companion.enumOf(p0) == amityLiveReactionReferenceType && Intrinsics.areEqual((Object)it.getReferenceId(), (Object)string))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @NotNull
    public final Completable addLiveReactions(@NotNull String liveStreamId, @NotNull List<AmityLiveReaction> reactions) {
        Intrinsics.checkNotNullParameter((Object)liveStreamId, (String)"liveStreamId");
        Intrinsics.checkNotNullParameter(reactions, (String)"reactions");
        Completable completable = new ReactionRemoteDataStore().addLiveReactions(liveStreamId, reactions).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"ignoreElement(...)");
        return completable;
    }

    private static final PagingSource getReactionPagingData$lambda$0(AmityReactionReferenceType $referenceType, String $referenceId, String $reactionName) {
        return new ReactionLocalDataStore().getReactionsPagingSource($referenceType, $referenceId, $reactionName);
    }
}

