/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.invitation;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.invitation.InvitationLocalDataStore;
import com.amity.socialcloud.sdk.core.data.invitation.InvitationModelMapper;
import com.amity.socialcloud.sdk.core.data.invitation.InvitationRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.invitation.InvitationRepository;
import com.amity.socialcloud.sdk.core.data.reaction.paging.InvitationMediator;
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitation;
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitationStatus;
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitationType;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.socket.request.CreateInvitationsRequest;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\"\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0012J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0012\u00a8\u0006\u001a"}, d2={"Lcom/amity/socialcloud/sdk/core/data/invitation/InvitationRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "<init>", "()V", "getDefaultPageSize", "", "getInvitationPagingData", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagingData;", "Lcom/amity/socialcloud/sdk/model/core/invitation/AmityInvitation;", "type", "Lcom/amity/socialcloud/sdk/model/core/invitation/AmityInvitationType;", "target", "Lcom/amity/socialcloud/sdk/core/data/reaction/paging/InvitationMediator$Target;", "getMyCommunityInvitation", "Lio/reactivex/rxjava3/core/Single;", "", "communityId", "", "createCommunityInvitations", "Lio/reactivex/rxjava3/core/Completable;", "userIds", "acceptInvitation", "invitationId", "rejectInvitation", "cancelInvitation", "amity-sdk_release"})
public final class InvitationRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<PagingData<AmityInvitation>> getInvitationPagingData(@NotNull AmityInvitationType type2, @NotNull InvitationMediator.Target target) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        DynamicQueryStreamPagerCreator pagerCreator = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null), null, new InvitationMediator(type2, target), () -> InvitationRepository.getInvitationPagingData$lambda$0(type2, target), (ModelMapper)new InvitationModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Single<List<AmityInvitation>> getMyCommunityInvitation(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Single single = InvitationRemoteDataStore.getMyInvitations$default(new InvitationRemoteDataStore(), AmityInvitationType.COMMUNITY_MEMBER, new InvitationMediator.Target.COMMUNITY(communityId), null, null, 12, null).flatMap((Function)getMyCommunityInvitation.1.INSTANCE).map((Function)getMyCommunityInvitation.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"map(...)");
        return single;
    }

    @NotNull
    public final Completable createCommunityInvitations(@NotNull String communityId, @NotNull List<String> userIds) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Completable completable = new InvitationRemoteDataStore().createInvitations(new CreateInvitationsRequest(AmityInvitationType.COMMUNITY_MEMBER.getValue(), communityId, "community", userIds)).flatMapCompletable((Function)createCommunityInvitations.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Completable acceptInvitation(@NotNull String invitationId) {
        Intrinsics.checkNotNullParameter((Object)invitationId, (String)"invitationId");
        Completable completable = new InvitationRemoteDataStore().acceptInvitations(invitationId).doOnSuccess(new Consumer(invitationId){
            final /* synthetic */ String $invitationId;
            {
                this.$invitationId = $invitationId;
            }

            public final void accept(JsonObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                new InvitationLocalDataStore().updateStatus(this.$invitationId, AmityInvitationStatus.APPROVED);
            }
        }).subscribeOn(Schedulers.io()).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"ignoreElement(...)");
        return completable;
    }

    @NotNull
    public final Completable rejectInvitation(@NotNull String invitationId) {
        Intrinsics.checkNotNullParameter((Object)invitationId, (String)"invitationId");
        Completable completable = new InvitationRemoteDataStore().rejectInvitations(invitationId).doOnSuccess(new Consumer(invitationId){
            final /* synthetic */ String $invitationId;
            {
                this.$invitationId = $invitationId;
            }

            public final void accept(JsonObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                new InvitationLocalDataStore().updateStatus(this.$invitationId, AmityInvitationStatus.REJECTED);
            }
        }).subscribeOn(Schedulers.io()).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"ignoreElement(...)");
        return completable;
    }

    @NotNull
    public final Completable cancelInvitation(@NotNull String invitationId) {
        Intrinsics.checkNotNullParameter((Object)invitationId, (String)"invitationId");
        Completable completable = new InvitationRemoteDataStore().cancelInvitations(invitationId).doOnSuccess(new Consumer(invitationId){
            final /* synthetic */ String $invitationId;
            {
                this.$invitationId = $invitationId;
            }

            public final void accept(JsonObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                new InvitationLocalDataStore().updateStatus(this.$invitationId, AmityInvitationStatus.CANCELLED);
            }
        }).subscribeOn(Schedulers.io()).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"ignoreElement(...)");
        return completable;
    }

    private static final PagingSource getInvitationPagingData$lambda$0(AmityInvitationType $type, InvitationMediator.Target $target) {
        return new InvitationLocalDataStore().getInvitationsPagingSource($type, $target);
    }
}

