package com.amity.socialcloud.sdk.social.domain.event

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.model.social.event.AmityEvent

internal class EventComposerUseCase : ComposerUseCase() {

    fun execute(event: AmityEvent): AmityEvent {
        addCreator(event)
        return event
    }

    private fun addCreator(event: AmityEvent) {
        event.creator = UserGetUseCase().execute(event.getUserId())
    }
}
