package com.amity.socialcloud.sdk.chat.data.message.preview

import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.data.model.MessagePreviewEntity
import io.reactivex.rxjava3.core.Completable
import org.joda.time.DateTime

internal class MessagePreviewLocalDataStore {
    
    fun getMessagePreview(messagePreviewId: String): MessagePreviewEntity? {
        return UserDatabase.get().messagePreviewDao().getByIdMessageIdNow(messagePreviewId)
    }
    
    fun getMessagePreviewByChannelId(channelId: String): MessagePreviewEntity? {
        return UserDatabase.get().messagePreviewDao().getByChannelId(channelId)
    }
    
    fun getMessagePreviewBySubChannelId(subChannelId: String): MessagePreviewEntity? {
        return UserDatabase.get().messagePreviewDao().getByIdNow(subChannelId)
    }
    
    fun saveMessagePreviews(
        messagePreviews: List<MessagePreviewEntity>,
    ): Completable {
        return Completable.fromAction {
            UserDatabase.get().messagePreviewDao().save(messagePreviews)
        }
    }
    
    fun saveMessagePreview(
        messagePreview: MessagePreviewEntity,
    ): Completable {
        return Completable.fromAction {
            UserDatabase.get().messagePreviewDao().save(listOf(messagePreview))
        }
    }
    
    fun deleteMessagePreview(messagePreviewId: String) {
        UserDatabase.get().messagePreviewDao().deleteById(messagePreviewId)
    }
    
    fun updateSubChannelInfo(subChannelId: String, subChannelName: String, subChannelUpdatedAt: DateTime): Completable {
        return Completable.fromAction {
            UserDatabase.get().messagePreviewDao().updateSubChannelInfo(subChannelId, subChannelName, subChannelUpdatedAt)
        }
    }
    
    fun clearDeletedMessagePreviews() {
        UserDatabase.get().messagePreviewDao().clearDeletedMessagePreviews()
    }
    
    fun clearAllMessagePreviews() {
        UserDatabase.get().messagePreviewDao().deleteAll()
    }
    
}