package com.amity.socialcloud.sdk.api.social.event

import com.amity.socialcloud.sdk.api.social.event.create.AmityEventCreateOptions
import com.amity.socialcloud.sdk.api.social.event.update.AmityEventUpdateOptions
import com.amity.socialcloud.sdk.model.social.event.AmityEvent
import com.amity.socialcloud.sdk.social.domain.event.EventLiveObjectUseCase
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.core.Single

class AmityEventRepository internal constructor() {

    /* begin_public_function
	  id: event.get
	  namespace: event_repository
	  api_style: live_object
	*/
    /**
     * Gets a LiveObject of event
     * @param [eventId] an eventId
     * @return LiveObject of event as Flowable<AmityEvent>
     */
    fun getEvent(eventId: String): Flowable<AmityEvent> {
        return EventLiveObjectUseCase().execute(eventId)
    }
    /* end_public_function */

    /* begin_public_function
	  id: event.create
	  namespace: event_repository
	  api_style: async
	*/
    /**
     * Initiates a function chain to create an event.
     * @return new instance of AmityEventCreateOptions.Builder.
     */
    fun createEvent(): AmityEventCreateOptions.Builder {
        return AmityEventCreateOptions.Builder()
    }
    /* end_public_function */

    /* begin_public_function
	  id: event.update
	  namespace: event_repository
	  api_style: async
	*/
    /**
     * Initiates a function chain to update an event.
     * @param [eventId] the ID of the event to update
     * @return new instance of AmityEventUpdateOptions.Builder.
     */
    fun updateEvent(eventId: String): AmityEventUpdateOptions.Builder {
        return AmityEventUpdateOptions.Builder(eventId)
    }
    /* end_public_function */

    /* begin_public_function
	  id: event.delete
	  namespace: event_repository
	  api_style: async
	*/
    /**
     * Deletes an event
     * @param [eventId] the ID of the event to delete
     * @return Async completion as Completable
     */
    fun deleteEvent(eventId: String): io.reactivex.rxjava3.core.Completable {
        return com.amity.socialcloud.sdk.social.domain.event.DeleteEventUseCase().execute(eventId)
    }
    /* end_public_function */

}
