package com.amity.socialcloud.sdk.model.core.reaction

import android.os.Parcelable
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.ekoapp.ekosdk.ReactorObject
import kotlinx.parcelize.Parcelize
import org.joda.time.DateTime

@Parcelize
data class AmityReaction internal constructor(
    private val reactionId: String,
    private val referenceType: String,
    private val referenceId: String,
    private val reactionName: String,
    private val userId: String,
    internal var user: AmityUser? = null,
    private val createdAt: DateTime
) : Parcelable, ReactorObject {

    sealed class Reference {

        class MESSAGE(private val messageId: String) : Reference() {
            fun getMessageId(): String {
                return messageId
            }
        }

        class POST(private val postId: String) : Reference() {
            fun getPostId(): String {
                return postId
            }
        }

        class COMMENT(private val commentId: String) : Reference() {
            fun getCommentId(): String {
                return commentId
            }
        }

        object UNKNOWN : Reference()

        companion object {
            internal fun from(referenceType: String, referenceId: String): Reference {
                return when (referenceType) {
                    "message" -> {
                        MESSAGE(referenceId)
                    }
                    "post" -> {
                        POST(referenceId)
                    }
                    "comment" -> {
                        COMMENT(referenceId)
                    }
                    else -> {
                        UNKNOWN
                    }
                }
            }
        }

    }


    fun getReactionId(): String {
        return reactionId
    }

    fun getReference(): Reference {
        return Reference.from(referenceType, referenceId)
    }

    fun getReactionName(): String {
        return reactionName
    }

    fun getCreator(): AmityUser? {
        return user
    }

    fun getCreatorId(): String {
        return userId
    }

    @Deprecated("Use getCreator()?.getDisplayName() instead")
    fun getCreatorDisplayName(): String {
        return user?.getDisplayName() ?: ""
    }

    fun getCreatedAt(): DateTime {
        return createdAt
    }

    override fun updatedAt(): DateTime {
        return createdAt
    }

    override fun uniqueId(): String {
        return reactionId
    }

}