package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import com.google.common.base.Objects

@Entity(tableName = "push_config", primaryKeys = ["userId", "deviceId"])
class EkoPushConfig(var userId: String, var deviceId: String, var state: State) {
	enum class State(val apiKey: String) {
		REGISTERED("registered"),
		UNREGISTERED("unregistered");
		
		companion object {
			@JvmStatic
            fun enumOf(apiKey: String?): State? {
				return values().find { it.apiKey == apiKey } ?: UNREGISTERED
			}
		}
	}
	
	override fun equals(obj: Any?): Boolean {
		if (obj == null) return false
		if (obj === this) return true
		if (obj.javaClass != javaClass) return false
		val other = obj as EkoPushConfig
		return (Objects.equal(userId, other.userId)
				&& Objects.equal(deviceId, other.deviceId)
				&& Objects.equal(state, other.state))
	}
	
	override fun hashCode(): Int {
		return Objects.hashCode(userId,
				deviceId,
				state)
	}
}