package com.ekoapp.ekosdk.internal.api.http.request

import com.google.gson.annotations.SerializedName

class RegisterDeviceForPushNotificationRequest private constructor(
	@field:SerializedName("userId") var userId: String?,
	@field:SerializedName("deviceId") var deviceId: String?,
	@field:SerializedName("token") var token: String,
	@field:SerializedName("provider") var provider: String
) {
	
	@SerializedName("platform")
	var platform = "android"
	
	class BaiduToken(
		@field:SerializedName("token") var token: String?,
		@field:SerializedName("userId") var userId: String?,
		@field:SerializedName("channelId") var channelId: String?)
	
	companion object {
		fun create(
			userId: String?,
			deviceId: String?,
			token: String,
			provider: String
		): RegisterDeviceForPushNotificationRequest {
			return RegisterDeviceForPushNotificationRequest(userId, deviceId, token, provider)
		}
	}
}