package com.amity.socialcloud.sdk.social.domain.community

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.amity.socialcloud.sdk.model.social.community.AmityCommunity
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityMembershipStatusFilter
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors


internal class SemanticSearchCommunitiesUseCase {

    fun execute(
        query: String,
        filter: AmityCommunityMembershipStatusFilter?,
        tags: AmityTags?,
        categoryIds: List<String>?,
    ): Flowable<PagingData<AmityCommunity>> {
        return CommunityRepository().searchCommunities(
            query = query,
            filter = filter,
            tags = tags,
            categoryIds = categoryIds,
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { community ->
                CommunityComposerUseCase().execute(community)
            }
        }
    }

}