package com.ekoapp.ekosdk.internal

import com.google.common.base.MoreObjects
import com.google.common.base.Objects

class EkoLocalFlag {
	var isFlaggedByMe = false
	var syncedUpHash: String? = null
	override fun equals(obj: Any?): Boolean {
		return when {
			obj == null -> false
			obj === this -> true
			obj.javaClass != javaClass -> false
			else -> {
				val other = obj as EkoLocalFlag
				(Objects.equal(isFlaggedByMe, other.isFlaggedByMe)
					&& Objects.equal(syncedUpHash, other.syncedUpHash))
			}
		}
	}
	
	override fun hashCode(): Int {
		return Objects.hashCode(
				isFlaggedByMe,
				syncedUpHash
		)
	}
	
	override fun toString(): String {
		return MoreObjects.toStringHelper(this)
				.add("isFlaggedByMe", isFlaggedByMe)
				.add("syncedUpHash", syncedUpHash)
				.toString()
	}
}