package com.amity.socialcloud.sdk.social.domain.category.query

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.model.social.category.AmityCommunityCategory
import com.amity.socialcloud.sdk.api.social.category.query.AmityCommunityCategorySortOption
import com.amity.socialcloud.sdk.social.data.category.CategoryRepository
import com.amity.socialcloud.sdk.social.domain.category.CategoryComposerUseCase
import com.amity.socialcloud.sdk.social.domain.community.member.CommunityMemberComposerUseCase
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class QueryCommunityCategoryListPagingDataUseCase {

    fun execute(sortOption: AmityCommunityCategorySortOption,
                isDeleted: Boolean?): Flowable<PagingData<AmityCommunityCategory>> {
        return CategoryRepository().getAllCategoriesPagingData(sortOption, isDeleted)
            .map { pagingData ->
                pagingData.map(Executors.newSingleThreadExecutor()) { category ->
                    CategoryComposerUseCase().execute(category)
                }
            }
    }

}
