package com.ekoapp.ekosdk.internal.api.socket.request

data class CommentQueryRequest(
    val referenceId: String? = null,
    val referenceType: String? = null,
    val filterByParentId: Boolean? = null,
    val parentId: String? = null,
    val isDeleted: Boolean? = null,
    val sortBy: String? = null,
    val options: CommentQueryRequestOptions = CommentQueryRequestOptions(),
    val dataTypes: CommentQueryAttachmentFilter? = null
) {

    //for cursor based pagination use first, last, after, before, and type "scrollable".
    //first is firstCreated,, integer is pageSize.
    //last is lastCreated, integer is pageSize.
    //do not send sort option.
    //
    //for offset based pagination use skip, limit, and type "pagination".
    //sort option is only available for offset based.
    data class CommentQueryRequestOptions(
        var after: Int? = null,
        var before: Int? = null,
        var first: Int? = null,
        var last: Int? = null,
        var limit: Int? = null,
        var skip: Int? = null,
        var type: String = "pagination",
        var token: String? = null
    )

    data class CommentQueryAttachmentFilter(
        var values: List<String>? = null,
        var matchType: String? = null
    )
}

