package com.amity.socialcloud.sdk.core.data.follow

import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatusFilter
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.EkoFollowListDto
import com.ekoapp.ekosdk.internal.api.dto.EkoFollowQueryDto
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class FollowRemoteDataStore {

    fun requestFollow(userId: String): Single<EkoFollowListDto> {
        return AmityHttpClient.get(FollowApi::class).flatMap {
            it.requestFollow(userId)
        }
    }

    fun unfollow(userId: String): Single<EkoFollowListDto> {
        return AmityHttpClient.get(FollowApi::class).flatMap {
            it.unfollow(userId)
        }
    }

    fun acceptFollow(userId: String): Single<EkoFollowListDto> {
        return AmityHttpClient.get(FollowApi::class).flatMap {
            it.acceptFollow(userId)
        }
    }

    fun declineFollow(userId: String): Single<EkoFollowListDto> {
        return AmityHttpClient.get(FollowApi::class).flatMap {
            it.declineFollow(userId)
        }
    }

    fun getMyFollowInfo(): Single<EkoFollowListDto> {
        return AmityHttpClient.get(FollowApi::class).flatMap {
            it.getMyFollowInfo()
        }
    }

    fun getUserFollowInfo(userId: String): Single<EkoFollowListDto> {
        return AmityHttpClient.get(FollowApi::class).flatMap {
            it.getUserFollowInfo(userId)
        }
    }

    fun getMyFollowers(
        filter: AmityFollowStatusFilter,
        limit: Int? = null,
        token: String? = null
    ): Single<EkoFollowQueryDto> {
        return AmityHttpClient.get(FollowApi::class).flatMap {
            it.queryMyFollowers(
                status = filter.apiKey,
                limit = limit,
                token = token
            )
        }
    }

    fun getUserFollowers(
        userId: String,
        filter: AmityFollowStatusFilter,
        limit: Int? = null,
        token: String? = null
    ): Single<EkoFollowQueryDto> {
        return AmityHttpClient.get(FollowApi::class).flatMap {
            it.queryUserFollowers(
                userId = userId,
                status = filter.apiKey,
                limit = limit,
                token = token
            )
        }
    }

    fun getMyFollowings(
        filter: AmityFollowStatusFilter,
        limit: Int? = null,
        token: String? = null
    ): Single<EkoFollowQueryDto> {
        return AmityHttpClient.get(FollowApi::class).flatMap {
            it.queryMyFollowings(
                status = filter.apiKey,
                limit = limit,
                token = token
            )
        }
    }

    fun getUserFollowings(
        userId: String,
        filter: AmityFollowStatusFilter,
        limit: Int? = null,
        token: String? = null
    ): Single<EkoFollowQueryDto> {
        return AmityHttpClient.get(FollowApi::class).flatMap {
            it.queryUserFollowings(
                userId = userId,
                status = filter.apiKey,
                limit = limit,
                token = token
            )
        }
    }

    fun blockUser(userId: String): Single<EkoFollowQueryDto> {
        return AmityHttpClient.get(FollowApi::class).flatMap {
            it.blockUser(userId)
        }
    }

    fun unblockUser(userId: String): Single<EkoFollowQueryDto> {
        return AmityHttpClient.get(FollowApi::class).flatMap {
            it.unblockUser(userId)
        }
    }

    fun getBlockedUsers(
        limit: Int? = null,
        token: String? = null
    ): Single<EkoFollowQueryDto> {
        return AmityHttpClient.get(FollowApi::class).flatMap {
            it.queryBlockedUsers(
                limit = limit,
                token = token
            )
        }
    }
}