package com.ekoapp.ekosdk.internal.usecase.permission

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.core.data.permission.PermissionRepository
import com.amity.socialcloud.sdk.model.core.permission.AmityPermission
import io.reactivex.rxjava3.core.Flowable

internal class CommunityPermissionValidatorUseCase {

    fun execute(permission: AmityPermission, communityId: String): Flowable<Boolean> {
        val membershipPermission =
            PermissionRepository().getCommunityPermission(communityId, AmityCoreClient.getUserId())
        val globalPermission =
            PermissionRepository().getGlobalPermission(AmityCoreClient.getUserId())
        return Flowable.combineLatest(membershipPermission, globalPermission) { t1, t2 ->
            t1.contains(permission) || t2.contains(permission)
        }
    }

}