package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.data.model.EkoPostFlag
import io.reactivex.Flowable

@Dao
abstract class EkoPostFlagDao : EkoObjectDao<EkoPostFlag>() {
	@Query("DELETE from post_flag")
	abstract override fun deleteAll()
	
	@Query("SELECT * from post_flag where postId = :postId LIMIT 1")
	abstract fun getByIdNowImpl(postId: String): EkoPostFlag
	override fun getByIdNow(postId: String): EkoPostFlag {
		return getByIdNowImpl(postId)
	}
	
	@Query("SELECT *" +
			" from post_flag" +
			" where post_flag.postId = :postId" +
			" LIMIT 1")
	abstract fun getByPostIdImpl(postId: String): Flowable<EkoPostFlag>
	fun getByPostId(postId: String): Flowable<EkoPostFlag> {
		return getByPostIdImpl(postId)
	}
}